/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.mail;

import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;

public class MailHelper {
    protected static Log log = LogFactory.getLog(MailHelper.class);
    private String host;
    protected int port = 0;
    private String userName;
    private String password;
    protected boolean debug;
    private String protocol;
    private String security;

    public void init(Session session) {
        this.protocol = "smtp";
    }

    public void init(Properties props) {
        this.protocol = props.getProperty("mail.protocol");
        this.host = props.getProperty("mail.host");
        String portStr = props.getProperty("mail.port");
        this.userName = props.getProperty("mail.user");
        this.password = props.getProperty("mail.password");
        this.security = props.getProperty("mail.security");
        if (portStr != null) {
            this.port = Integer.parseInt(portStr);
        }
        this.debug = Boolean.valueOf(props.getProperty("debug"));
    }

    public String getSecurity() {
        return this.security;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDisplayString() {
        return this.getUserName() + "@" + this.getHost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session createMailSession(String protocol, String host, int port, String userName, String password, String type) {
        Session session;
        Properties props;
        protocol = protocol.toLowerCase();
        boolean secure = false;
        if (protocol.equals("smtps")) {
            protocol = "smtp";
            secure = true;
        } else if (protocol.equals("pop3s")) {
            protocol = "pop3";
            secure = true;
        } else if (protocol.equals("imaps")) {
            protocol = "imap";
            secure = true;
        }
        Properties properties = props = new Properties();
        synchronized (properties) {
            if ("tls".equalsIgnoreCase(type)) {
                props.put("mail.smtp.starttls.enable", "true");
            }
            if ("ssl".equalsIgnoreCase(type)) {
                props.put("mail.smtp.socketFactory.port", Integer.toString(port));
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            props.put("mail.transport.protocol", protocol);
            props.put("mail." + protocol + ".host", host);
            props.put("mail." + protocol + ".port", String.valueOf(port));
            if (secure) {
                System.setProperty("mail." + protocol + ".socketFactory.port", String.valueOf(port));
            }
            props.setProperty("mail." + protocol + ".rsetbeforequit", "true");
            if (password != null) {
                props.put("mail." + protocol + ".auth", "true");
                DefaultAuthenticator auth = null;
                if (auth == null) {
                    auth = new DefaultAuthenticator(userName, password);
                }
                session = Session.getInstance((Properties)props, auth);
            } else {
                props.put("mail." + protocol + ".auth", "false");
                session = Session.getDefaultInstance((Properties)props, null);
            }
        }
        return session;
    }

    private static byte[] toBytes(Message msg) throws IOException, MessagingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)baos);
        baos.close();
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    private static class DefaultAuthenticator
    extends Authenticator {
        private String username = null;
        private String password = null;

        public DefaultAuthenticator(String user, String pwd) {
            this.username = user;
            this.password = pwd;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

