/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.mail;

import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.MessageTransformer;
import com.tplus.transform.runtime.PropertyMap;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.mail.DataHandlerRawMessage;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MailMessageTransformer
implements MessageTransformer {
    public static final String CONTENT_TYPE_PROPERTY = "contentType";
    public static final String TO_ADDRESSES_PROPERTY = "toAddresses";
    public static final String CC_ADDRESSES_PROPERTY = "ccAddresses";
    public static final String BCC_ADDRESSES_PROPERTY = "bccAddresses";
    public static final String FROM_ADDRESS_PROPERTY = "fromAddress";
    public static final String REPLY_TO_ADDRESSES_PROPERTY = "replyToAddresses";
    public static final String SUBJECT_PROPERTY = "subject";
    public static final String CUSTOM_HEADERS_MAP_PROPERTY = "customHeaders";
    public static final String SENT_DATE_PROPERTY = "sentDate";
    protected static Log log = LogFactory.getLog(MailMessageTransformer.class);
    public static final String MAIL_HEADER_PREFIX = "mailHeader";
    public static final String MAIL_PREFIX = "mail";

    private byte[] getPayload(Part messagePart) throws Exception {
        String contentType = messagePart.getContentType();
        InputStream is = messagePart.getInputStream();
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        byte[] bytes = IOUtil.readStream(is);
        return bytes;
    }

    public RawMessage createRawMessage(Object message) throws TransformException {
        if (!(message instanceof Message)) {
            throw TransformException.createFormatted(TransformException.class, "CLNT171", message.getClass().getName());
        }
        Message msg = (Message)message;
        try {
            Object content = msg.getContent();
            ByteArrayInputSource rawMessage = null;
            if (content instanceof Multipart) {
                BodyPart messagePart = ((Multipart)content).getBodyPart(0);
                byte[] payload = this.getPayload((Part)messagePart);
                rawMessage = new ByteArrayInputSource(payload);
                log.debug("Received Multipart message");
                for (int i = 1; i < ((Multipart)content).getCount(); ++i) {
                    BodyPart part = ((Multipart)content).getBodyPart(i);
                    String name = part.getFileName();
                    if (name == null) {
                        name = String.valueOf(i - 1);
                    }
                    DataHandlerRawMessage attachMessage = new DataHandlerRawMessage(part.getDataHandler());
                    rawMessage.addAttachment(name, attachMessage);
                    this.addAttachmentHeaders(attachMessage, name, (Part)part);
                }
            } else {
                byte[] payload = this.getPayload((Part)msg);
                rawMessage = new ByteArrayInputSource(payload);
            }
            PropertyMap mailProperties = rawMessage.getProperties(MAIL_PREFIX);
            mailProperties.setProperty(TO_ADDRESSES_PROPERTY, MailMessageTransformer.mailAddressesToString(msg.getRecipients(Message.RecipientType.TO)));
            mailProperties.setProperty(CC_ADDRESSES_PROPERTY, MailMessageTransformer.mailAddressesToString(msg.getRecipients(Message.RecipientType.CC)));
            mailProperties.setProperty(BCC_ADDRESSES_PROPERTY, MailMessageTransformer.mailAddressesToString(msg.getRecipients(Message.RecipientType.BCC)));
            mailProperties.setProperty(REPLY_TO_ADDRESSES_PROPERTY, MailMessageTransformer.mailAddressesToString(msg.getReplyTo()));
            mailProperties.setProperty(FROM_ADDRESS_PROPERTY, MailMessageTransformer.mailAddressesToString(msg.getFrom()));
            mailProperties.setProperty(SUBJECT_PROPERTY, msg.getSubject());
            mailProperties.setProperty(CONTENT_TYPE_PROPERTY, msg.getContentType());
            mailProperties.setProperty(SENT_DATE_PROPERTY, msg.getSentDate());
            PropertyMap headerProperties = rawMessage.getProperties(MAIL_HEADER_PREFIX);
            Enumeration e = msg.getAllHeaders();
            while (e.hasMoreElements()) {
                Header h = (Header)e.nextElement();
                headerProperties.setProperty(h.getName(), h.getValue());
            }
            return rawMessage;
        }
        catch (Exception e) {
            throw new TransformException("Error reading mail message", e);
        }
    }

    protected void addAttachmentHeaders(RawMessage attachMessage, String name, Part part) throws MessagingException {
        PropertyMap headerProperties = attachMessage.getProperties(MAIL_HEADER_PREFIX);
        Enumeration e = part.getAllHeaders();
        while (e.hasMoreElements()) {
            Header h = (Header)e.nextElement();
            headerProperties.setProperty(h.getName(), h.getValue());
        }
    }

    public static String internetAddressesToString(InternetAddress[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < addresses.length; ++i) {
            InternetAddress address = addresses[i];
            buf.append(address.getAddress());
            if (i >= addresses.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public static String internetAddressesToString(InternetAddress address) {
        return MailMessageTransformer.internetAddressesToString(new InternetAddress[]{address});
    }

    public static String mailAddressesToString(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < addresses.length; ++i) {
            Address address = addresses[i];
            buf.append(address.toString());
            if (i >= addresses.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public static String mailAddressesToString(Address address) {
        return MailMessageTransformer.mailAddressesToString(new Address[]{address});
    }

    public static InternetAddress[] stringToInternetAddresses(String address) throws AddressException {
        if (StringUtils.isEmpty(address)) {
            throw new NullPointerException("Email address is empty");
        }
        InternetAddress[] inetaddresses = InternetAddress.parse((String)address, (boolean)false);
        return inetaddresses;
    }
}

