/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.mail;

import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.OutputDeviceFactory;
import com.tplus.transform.runtime.OutputProtocol;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.mail.MailOutputDevice;
import com.tplus.transform.runtime.mail.MailSource;
import com.tplus.transform.runtime.mail.SMTPHelper;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.naming.NamingException;

public class MailOutputDeviceFactory
implements OutputDeviceFactory {
    protected static Log log = LogFactory.getLog(MailOutputDeviceFactory.class);
    SMTPHelper smtpHelper = new SMTPHelper();
    public static final int RETRIES = 3;
    private OutputProtocol factoryBean;
    String factoryName;
    MailSource mailSource;

    public MailOutputDeviceFactory(String factoryName, OutputProtocol factoryBean) {
        this.factoryName = factoryName;
        this.factoryBean = factoryBean;
    }

    public void init(MailSource mailSource) throws NamingException, MessagingException {
        this.mailSource = mailSource;
        mailSource.connect();
    }

    protected void sendMessage(Object value, String messageIdentifier) throws TransformException, IOException, MessagingException {
        this.mailSource.send(value);
    }

    public void write(String messageIdentifier, Object data) throws NamingException, TransformException, MessagingException {
        Object value = data;
        if (value == null) {
            throw TransformException.createFormatted("SRT710");
        }
        for (int i = 0; i < 3; ++i) {
            try {
                this.sendMessage(value, messageIdentifier);
                break;
            }
            catch (MessagingException e) {
                if (i == 2) {
                    throw e;
                }
                this.cleanup();
                continue;
            }
            catch (IOException e) {
                log.warn(e.getMessage(), e);
            }
        }
    }

    void reconnect() throws NamingException, MessagingException {
        this.smtpHelper.reconnect();
    }

    public OutputDevice createDevice(DeviceInfo deviceInfo, TransformContext cxt) throws TransformException {
        String deviceName = deviceInfo.getDeviceFactoryName();
        if (deviceName == null) {
            throw TransformException.createFormatted("SRT711");
        }
        MailOutputDevice device = new MailOutputDevice(deviceInfo, this.factoryBean);
        return device;
    }

    public void send(Object message, DeviceInfo info, TransformContext cxt) throws TransformException {
        String deviceFactoryName = info.getDeviceFactoryName();
        String messageIdentifier = info.getMessageIdentifier();
        try {
            this.write(messageIdentifier, message);
        }
        catch (NamingException e) {
            TransformException te = TransformException.createFormatted("SRT901", new Object[]{deviceFactoryName});
            te.setDetail(e);
            throw te;
        }
        catch (MessagingException e) {
            TransformException te = TransformException.createFormatted("SRT902", new Object[]{deviceFactoryName});
            te.setDetail(e);
            throw te;
        }
    }

    public void cleanup() throws MessagingException {
        this.smtpHelper.disconnect();
    }
}

