/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.mail;

import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.LookupContextFactory;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.OutputProtocol;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.mail.MailOutputDeviceFactory;
import com.tplus.transform.runtime.mail.MailSource;
import com.tplus.transform.util.log.Log;
import java.util.HashMap;
import java.util.Map;
import javax.mail.MessagingException;
import javax.naming.NamingException;

public class MailOutputProtocolImpl
implements OutputProtocol {
    Map factories = new HashMap();
    static Log log = LogFactory.getRuntimeLog("mailbean");

    public void cleanup() throws MessagingException {
        for (MailOutputDeviceFactory factory : this.factories.values()) {
            factory.cleanup();
        }
        this.factories.clear();
    }

    protected MailOutputDeviceFactory getFactory(String name) throws NamingException, MessagingException {
        MailOutputDeviceFactory factory = (MailOutputDeviceFactory)this.factories.get(name);
        if (factory == null) {
            factory = this.createOutputDeviceFactory(name);
            this.factories.put(name, factory);
        }
        return factory;
    }

    protected MailOutputDeviceFactory createOutputDeviceFactory(String factoryName) throws NamingException, MessagingException {
        MailOutputDeviceFactory factory = new MailOutputDeviceFactory(factoryName, this);
        LookupContext lookupContext = LookupContextFactory.getLookupContext();
        MailSource mailSource = (MailSource)lookupContext.lookupComponent(factoryName);
        factory.init(mailSource);
        return factory;
    }

    public OutputDevice createDevice(DeviceInfo deviceInfo, TransformContext cxt) throws TransformException {
        String deviceFactoryName = deviceInfo.getDeviceFactoryName();
        try {
            MailOutputDeviceFactory factory = this.getFactory(deviceFactoryName);
            OutputDevice device = factory.createDevice(deviceInfo, cxt);
            return device;
        }
        catch (NamingException e) {
            TransformException te = TransformException.createFormatted("SRT901", new Object[]{deviceFactoryName});
            te.setDetail(e);
            log.error(te.getMessage(), e);
            throw te;
        }
        catch (MessagingException e) {
            TransformException te = TransformException.createFormatted("SRT902", new Object[]{deviceFactoryName});
            te.setDetail(e);
            log.error(te.getMessage(), e);
            throw te;
        }
    }

    public void send(Object data, DeviceInfo deviceInfo, TransformContext cxt) throws TransformException {
        String deviceFactoryName = deviceInfo.getDeviceFactoryName();
        try {
            MailOutputDeviceFactory factory = this.getFactory(deviceFactoryName);
            factory.send(data, deviceInfo, cxt);
        }
        catch (NamingException e) {
            TransformException te = TransformException.createFormatted("SRT901", new Object[]{deviceFactoryName});
            te.setDetail(e);
            throw te;
        }
        catch (MessagingException e) {
            TransformException te = TransformException.createFormatted("SRT902", new Object[]{deviceFactoryName});
            te.setDetail(e);
            throw te;
        }
    }
}

