/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.mail;

import com.tplus.transform.runtime.Binary;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.PropertyMap;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.StringInputSource;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.collection.StringList;
import com.tplus.transform.runtime.mail.MailHelper;
import com.tplus.transform.runtime.mail.MailMessageTransformer;
import com.tplus.transform.runtime.mail.MailSource;
import com.tplus.transform.util.ArrayUtils;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.IOException;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;

public class SMTPHelper
extends MailHelper
implements MailSource {
    protected static Log log = LogFactory.getLog(SMTPHelper.class);
    public static final int DEFAULT_SMTP_PORT = 25;
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private Session session;
    private String bcc;
    private String to;
    private String cc;
    private String replyTo;
    private String defaultSubject = "";
    private String from;
    private Properties customHeaders = new Properties();
    private Authenticator authenticator = null;
    private String contentType = "text/plain";
    Transport transport;

    public SMTPHelper() {
        this.port = 25;
    }

    public void init(Properties props) {
        super.init(props);
        this.from = props.getProperty(this.toMailPropertyName("fromAddress"));
        this.to = props.getProperty(this.toMailPropertyName("toAddresses"));
        this.cc = props.getProperty(this.toMailPropertyName("ccAddresses"));
        this.bcc = props.getProperty(this.toMailPropertyName("bccAddresses"));
        this.replyTo = props.getProperty(this.toMailPropertyName("replyToAddresses"));
        this.contentType = props.getProperty(this.toMailPropertyName("contentType"));
        this.defaultSubject = props.getProperty(this.toMailPropertyName("subject"));
        if (this.defaultSubject == null) {
            this.defaultSubject = "";
        }
    }

    public void init(Session session) {
        super.init(session);
        this.session = session;
    }

    private String toMailPropertyName(String name) {
        return "mail." + name;
    }

    public String getCcAddresses() {
        return this.cc;
    }

    public String getBccAddresses() {
        return this.bcc;
    }

    public String getFromAddress() {
        return this.from;
    }

    public String getReplyToAddresses() {
        return this.replyTo;
    }

    public String getSubject() {
        return this.defaultSubject;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Properties getCustomHeaders() {
        return this.customHeaders;
    }

    public String getToAddresses() {
        return this.to;
    }

    public void connect() throws MessagingException {
        if (this.transport == null) {
            if (this.session == null) {
                String protocol = this.getProtocol();
                if (protocol == null) {
                    protocol = "smtp";
                }
                this.session = SMTPHelper.createMailSession(protocol, this.getHost(), this.getPort(), this.getUserName(), this.getPassword(), this.getSecurity());
                this.session.setDebug(this.debug);
                this.transport = this.session.getTransport("smtp");
            } else {
                this.transport = this.session.getTransport("smtp");
            }
            this.transport.connect();
        }
    }

    public void disconnect() throws MessagingException {
        this.doDisconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect() throws MessagingException {
        try {
            if (this.transport != null) {
                this.transport.close();
            }
        }
        finally {
            this.transport = null;
            this.session = null;
        }
    }

    public Message transformToMailMessage(RawMessage rawMessage) throws TransformException {
        PropertyMap mailProperties = rawMessage.getProperties("mail");
        String to = mailProperties.getStringProperty("toAddresses", this.getToAddresses());
        String cc = mailProperties.getStringProperty("ccAddresses", this.getCcAddresses());
        String bcc = mailProperties.getStringProperty("bccAddresses", this.getBccAddresses());
        String from = mailProperties.getStringProperty("fromAddress", this.getFromAddress());
        String replyTo = mailProperties.getStringProperty("replyToAddresses", this.getReplyToAddresses());
        String subject = mailProperties.getStringProperty("subject", this.getSubject());
        String contentType = mailProperties.getStringProperty("contentType", this.getContentType());
        Properties headers = new Properties();
        Properties customHeaders = this.getCustomHeaders();
        if (customHeaders != null && !customHeaders.isEmpty()) {
            headers.putAll((Map<?, ?>)customHeaders);
        }
        PropertyMap mailHeaderProperties = rawMessage.getProperties("mailHeader");
        StringList headerProps = mailHeaderProperties.getPropertyNames();
        for (String propertyKey : headerProps) {
            headers.put(propertyKey, mailHeaderProperties.getStringProperty(propertyKey, ""));
        }
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(256);
            buf.append("Constructing email using:\n");
            buf.append("To: ").append(to);
            buf.append("From: ").append(from);
            buf.append("CC: ").append(cc);
            buf.append("BCC: ").append(bcc);
            buf.append("Subject: ").append(subject);
            buf.append("ReplyTo: ").append(replyTo);
            buf.append("Content type: ").append(contentType);
            buf.append("Payload type: ").append(rawMessage.getClass().getName());
            buf.append("Custom Headers: ").append(headers.toString());
            log.debug(buf.toString());
        }
        try {
            MimeMessage msg = new MimeMessage(this.session);
            msg.setRecipients(Message.RecipientType.TO, (Address[])MailMessageTransformer.stringToInternetAddresses(to));
            msg.setSentDate(Calendar.getInstance().getTime());
            if (!StringUtils.isEmpty(from)) {
                msg.setFrom((Address)MailMessageTransformer.stringToInternetAddresses(from)[0]);
            }
            if (!StringUtils.isEmpty(cc)) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])MailMessageTransformer.stringToInternetAddresses(cc));
            }
            if (!StringUtils.isEmpty(bcc)) {
                msg.setRecipients(Message.RecipientType.BCC, (Address[])MailMessageTransformer.stringToInternetAddresses(bcc));
            }
            if (!StringUtils.isEmpty(replyTo)) {
                msg.setReplyTo((Address[])MailMessageTransformer.stringToInternetAddresses(replyTo));
            }
            msg.setSubject(subject);
            for (Map.Entry<Object, Object> entry : headers.entrySet()) {
                msg.setHeader(entry.getKey().toString(), entry.getValue().toString());
            }
            Set attachmentNames = rawMessage.getAttachmentNames();
            if (attachmentNames.size() == 0) {
                this.setContent((Message)msg, rawMessage, contentType);
            } else {
                MimeMultipart mimeMultipart = this.setContentWithAttachment((Message)msg, rawMessage, contentType);
                for (String attName : attachmentNames) {
                    RawMessage attachment = rawMessage.getAttachment(attName);
                    this.setAttachment(mimeMultipart, attName, attachment);
                }
            }
            return msg;
        }
        catch (Exception e) {
            TransformException te = TransformException.createFormatted(TransformException.class, "CLNT174");
            te.setDetail(e);
            throw te;
        }
    }

    private void setAttachment(MimeMultipart mimeMultipart, String attName, RawMessage attachment) throws MessagingException, TransformException {
        PropertyMap mailProperties = attachment.getProperties("mail");
        String contentType = mailProperties.getStringProperty("contentType", this.getContentType());
        MimeBodyPart part = new MimeBodyPart();
        part.setFileName(attName);
        Object o = attachment.getAsObject();
        if (o instanceof Binary) {
            o = ((Binary)o).getAsBytes();
        }
        part.setContent(o, contentType);
        mimeMultipart.addBodyPart((BodyPart)part);
    }

    protected void setContent(Message msg, RawMessage src, String contentType) throws Exception {
        msg.setContent((Object)src.getAsString(), contentType);
    }

    protected MimeMultipart setContentWithAttachment(Message msg, RawMessage src, String contentType) throws Exception {
        MimeMultipart mimeMultipart = new MimeMultipart();
        msg.setContent((Multipart)mimeMultipart);
        MimeBodyPart part = new MimeBodyPart();
        part.setContent((Object)src.getAsString(), contentType);
        mimeMultipart.addBodyPart((BodyPart)part);
        return mimeMultipart;
    }

    public void reconnect() throws MessagingException {
        try {
            this.doDisconnect();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        this.connect();
    }

    public void send(Object o) throws TransformException, IOException, MessagingException {
        RawMessage raw;
        if (o instanceof RawMessage) {
            raw = (RawMessage)o;
        } else if (o instanceof String) {
            raw = new StringInputSource((String)o);
        } else if (o instanceof byte[]) {
            raw = new ByteArrayInputSource((byte[])o);
        } else {
            throw new TransformException("");
        }
        this.send(raw);
    }

    public void send(RawMessage rawMessage) throws TransformException, IOException, MessagingException {
        Message message = this.transformToMailMessage(rawMessage);
        this.sendMailMessage(message);
    }

    protected void sendMailMessage(Message message) throws MessagingException, IOException {
        message.setSentDate(Calendar.getInstance().getTime());
        Address[] toRecipients = message.getRecipients(Message.RecipientType.TO);
        Address[] ccRecipients = message.getRecipients(Message.RecipientType.CC);
        Address[] bccRecipients = message.getRecipients(Message.RecipientType.BCC);
        Address[] allReceipients = (Address[])ArrayUtils.add(ArrayUtils.add(toRecipients, ccRecipients), bccRecipients);
        this.sendMessage(message, allReceipients);
        if (log.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer();
            msg.append("Email message sent with subject'").append(message.getSubject()).append("' sent- ");
            msg.append(", From: ").append(MailMessageTransformer.mailAddressesToString(message.getFrom())).append(" ");
            msg.append(", To: ").append(MailMessageTransformer.mailAddressesToString(toRecipients)).append(" ");
            msg.append(", Cc: ").append(MailMessageTransformer.mailAddressesToString(message.getRecipients(Message.RecipientType.CC))).append(" ");
            msg.append(", Bcc: ").append(MailMessageTransformer.mailAddressesToString(message.getRecipients(Message.RecipientType.BCC))).append(" ");
            msg.append(", ReplyTo: ").append(MailMessageTransformer.mailAddressesToString(message.getReplyTo()));
            log.debug(msg.toString());
        }
    }

    public void sendMessage(Message message, Address[] allReceipients) throws MessagingException {
        this.transport.sendMessage(message, allReceipients);
    }

    public static void cmtmain(String[] args) throws ParseException {
        ContentType type = new ContentType(DEFAULT_CONTENT_TYPE);
        System.out.println(type);
    }
}

