/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.metrics;

import com.tplus.transform.runtime.metrics.MetricLogger;
import com.tplus.transform.runtime.metrics.MetricManager;

public abstract class AbstractMetricLogger
implements MetricLogger {
    static final String METRICS_TAG = "VolanteMetrics-Info";
    static final String METRICS_START_TAG = "VolanteMetrics-SessionStart";
    static final String METRICS_CONFIG_CHANGED_TAG = "VolanteMetrics-ConfigChanged";
    static final String LAST_LOGGED_TAG = "LoggedTime";
    static final String SESSION_ID_TAG = "ID";
    static final String SESSION_START_TAG = "StartTime";
    static final String REPORTING_ENABLED_TAG = "ReportingEnabled";
    static final String METRICS_LOG_ACTIVITIES_TAG = "ActivitiesLogEnabled";
    static final String REPORT_COUNT_INTERVAL_TAG = "ReportCountInterval";
    static final String REPORT_TIME_INTERVAL_TAG = "ReportTimeInterval";
    String dateTimeFormat = "yyyyMMdd-HH:mm:ss";
    MetricManager metricManager;
    String reportFormat = "";

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setMetricManager(MetricManager metricManager) {
        this.metricManager = metricManager;
    }

    protected String getFormattedReportTimeInterval() {
        long minutes = this.metricManager.getReportTimeGranularity() / 60000L;
        if (minutes <= 0L) {
            return "OFF";
        }
        long hour = minutes / 60L;
        String reportTime = "";
        if (hour > 0L) {
            minutes %= 60L;
            reportTime = reportTime + hour + "H ";
        }
        reportTime = reportTime + minutes + "M";
        return reportTime;
    }

    protected String getReportCountInterval() {
        String reportCountGranularityStr = "OFF";
        long reportCountGranularity = this.metricManager.getReportCountGranularity();
        if (reportCountGranularity > 0L) {
            reportCountGranularityStr = Long.toString(reportCountGranularity);
        }
        return reportCountGranularityStr;
    }
}

