/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.metrics;

import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.metrics.AbstractMetricLogger;
import com.tplus.transform.runtime.metrics.MetricItem;
import com.tplus.transform.util.DateUtils;
import com.tplus.transform.util.log.Log;
import java.util.Date;

public class MetricCSVLogger
extends AbstractMetricLogger {
    protected static final Log log = LogFactory.getRuntimeLog("Stats");
    protected static final String TAG_SEPARATOR = ",";
    protected static final String VALUE_SEPARATOR = "=";
    private static final char QUOTE = '\"';
    private static final String CSV = "CSV";
    private Log.LogLevel level = Log.INFO;
    private String metricsStartLogData = null;

    public MetricCSVLogger() {
        this.reportFormat = CSV;
        this.dateTimeFormat = "yyyyMMdd-HH:mm:ss";
    }

    public void logReport() {
        Date lastReportedTime = new Date();
        this.metricManager.setLastReportedTime(lastReportedTime);
        if (this.metricsStartLogData == null) {
            this.metricsStartLogData = this.getMetricsStartLogData("VolanteMetrics-Info");
        }
        StringBuilder buffer = new StringBuilder(this.metricsStartLogData);
        this.quoteWithSeparator(buffer, "LoggedTime", DateUtils.formatDate(lastReportedTime, this.dateTimeFormat));
        long totalMetricCount = 0L;
        for (MetricItem metricItem : this.metricManager.getMetricItemsList()) {
            if (!metricItem.isEnabled()) continue;
            long metricCount = metricItem.getMetricCount();
            totalMetricCount += metricCount;
            this.quoteWithSeparator(buffer, metricItem.getName(), metricCount);
        }
        this.metricManager.setLastReportedMetricCount(totalMetricCount);
        String logString = buffer.toString();
        if (logString.endsWith(TAG_SEPARATOR)) {
            logString = logString.substring(0, logString.length() - TAG_SEPARATOR.length());
        }
        log.log(logString, this.level, null);
    }

    private String getMetricsStartLogData(String tagName) {
        StringBuilder buffer = new StringBuilder(500);
        buffer.append(tagName).append(TAG_SEPARATOR);
        this.quoteWithSeparator(buffer, "ID", this.metricManager.getSessionId());
        this.quoteWithSeparator(buffer, "StartTime", DateUtils.formatDate(this.metricManager.getSessionStartTime(), this.dateTimeFormat));
        return buffer.toString();
    }

    private void quote(StringBuilder buffer, String key, Object value) {
        buffer.append('\"').append(key).append(VALUE_SEPARATOR).append(value).append('\"');
    }

    private void quoteWithSeparator(StringBuilder buffer, String key, Object value) {
        buffer.append('\"').append(key).append(VALUE_SEPARATOR).append(value).append('\"').append(TAG_SEPARATOR);
    }

    public void logSession() {
        log.log(this.getConfigString("VolanteMetrics-SessionStart"), this.level, null);
    }

    private String getConfigString(String tag) {
        StringBuilder buffer = new StringBuilder(this.getMetricsStartLogData(tag));
        boolean reportingEnabled = this.metricManager.isReportingEnabled();
        this.quote(buffer, "ReportingEnabled", reportingEnabled);
        if (reportingEnabled) {
            buffer.append(TAG_SEPARATOR);
            this.quoteWithSeparator(buffer, "ActivitiesLogEnabled", this.metricManager.isReportActivities());
            this.quoteWithSeparator(buffer, "ReportCountInterval", this.getReportCountInterval());
            this.quote(buffer, "ReportTimeInterval", this.getFormattedReportTimeInterval());
        }
        return buffer.toString();
    }

    public void logConfigChange() {
        log.log(this.getConfigString("VolanteMetrics-ConfigChanged"), this.level, null);
    }
}

