/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.metrics;

import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.metrics.MetricCSVLogger;
import com.tplus.transform.runtime.metrics.MetricItem;
import com.tplus.transform.runtime.metrics.MetricLogFactory;
import com.tplus.transform.runtime.metrics.MetricLogger;
import com.tplus.transform.runtime.metrics.MetricType;
import com.tplus.transform.util.log.Log;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricManager {
    public static final String METRICS_REPORT_ENABLED = "volante.metrics.report.enabled";
    public static final String METRICS_REPORT_ACTIVITIES = "volante.metrics.report.logActivities";
    public static final String METRICS_REPORT_COUNT_INTERVAL = "volante.metrics.report.countInterval";
    public static final String METRICS_REPORT_TIME_INTERVAL = "volante.metrics.report.timeInterval";
    public static final String METRICS_REPORT_FORMAT = "volante.metrics.report.format";
    protected static final Log log = LogFactory.getRuntimeLog("Stats");
    private static final MetricManager instance = new MetricManager();
    private static final boolean DEFAULT_METRICS_REPORT_ENABLED = false;
    private static final boolean DEFAULT_METRICS_REPORT_ACTIVITY = true;
    private static final long DEFAULT_METRICS_REPORT_COUNT_INTERVAL = 1000L;
    private static final long DEFAULT_METRICS_REPORT_TIME_INTERVAL = 60L;
    private final Date sessionStartTime;
    private final String sessionId;
    private long reportCountGranularity;
    private long reportTimeGranularity;
    private ArrayList<MetricItem> metricItemsList = new ArrayList();
    private Date lastReportedTime = this.sessionStartTime = new Date();
    private long lastReportedMetricCount;
    private boolean reportingEnabled;
    private boolean reportActivities;
    private MetricLogger metricLogger;

    private MetricManager() {
        String hostName = "localhost";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.sessionId = (hostName == null ? "9999999999" : Integer.valueOf(hostName.hashCode())) + ":" + this.sessionStartTime.getTime();
        this.metricLogger = new MetricCSVLogger();
        this.metricLogger.setMetricManager(this);
        this.loadMetricConfig();
    }

    public static MetricManager getInstance() {
        return instance;
    }

    boolean isReportActivities() {
        return this.reportActivities;
    }

    private void setReportActivities(boolean reportActivities) {
        this.reportActivities = reportActivities;
        for (MetricItem metricItem : this.metricItemsList) {
            this.configureReportingItem(metricItem);
        }
    }

    private void loadMetricConfig() {
        boolean report = this.getReportingEnabledConfig();
        long reportCount = 0L;
        String reportTime = null;
        boolean reportActivity = report;
        if (report) {
            reportCount = this.getReportCountConfig();
            reportTime = this.getReportTimeConfig();
            reportActivity = this.getActivityReportingConfig();
        }
        this.configMetrics(report, reportActivity, reportCount, reportTime, false);
    }

    public void configMetrics(boolean reportingEnabled, boolean activityReportingEnabled, long reportCountGranularity, String reportTimeStr) {
        this.configMetrics(reportingEnabled, activityReportingEnabled, reportCountGranularity, reportTimeStr, false);
    }

    private void configMetrics(boolean reportingEnabled, boolean activityReportingEnabled, long reportCountGranularity, String reportTimeStr, boolean logConfigChange) {
        this.setReportingEnabled(reportingEnabled);
        this.setReportActivities(activityReportingEnabled);
        this.setReportCountGranularity(reportCountGranularity);
        this.setReportTimeGranularity(this.parseReportTime(reportTimeStr));
        if (logConfigChange) {
            this.metricLogger.logConfigChange();
        }
    }

    Date getSessionStartTime() {
        return this.sessionStartTime;
    }

    MetricLogger getMetricLogger() {
        return this.metricLogger;
    }

    private void setMetricLogger(String reportFormat) {
        if (this.metricLogger == null || !this.metricLogger.getReportFormat().equalsIgnoreCase(reportFormat)) {
            this.setMetricLogger(MetricLogFactory.getMetricLogger(reportFormat));
        }
    }

    private void setMetricLogger(MetricLogger metricLogger) {
        this.metricLogger = metricLogger;
        this.metricLogger.setMetricManager(this);
    }

    List<MetricItem> getMetricItemsList() {
        return this.metricItemsList;
    }

    String getSessionId() {
        return this.sessionId;
    }

    Date getLastReportedTime() {
        return this.lastReportedTime;
    }

    void setLastReportedTime(Date lastReportedTime) {
        this.lastReportedTime = lastReportedTime;
    }

    long getLastReportedMetricCount() {
        return this.lastReportedMetricCount;
    }

    void setLastReportedMetricCount(long lastReportedMetricCount) {
        this.lastReportedMetricCount = lastReportedMetricCount;
    }

    boolean isReportingEnabled() {
        return this.reportingEnabled;
    }

    private void setReportingEnabled(boolean reportingEnabled) {
        this.reportingEnabled = reportingEnabled;
    }

    void addMetricItem(MetricItem metricItem) {
        this.configureReportingItem(metricItem);
        this.metricItemsList.add(metricItem);
    }

    private void configureReportingItem(MetricItem metricItem) {
        boolean enabled = metricItem.getMetricType() == MetricType.FLOW || this.reportActivities;
        metricItem.setEnabled(enabled);
    }

    long getReportTimeGranularity() {
        return this.reportTimeGranularity;
    }

    private void setReportTimeGranularity(long reportTimeGranularity) {
        this.reportTimeGranularity = reportTimeGranularity * 60L * 1000L;
    }

    long getReportCountGranularity() {
        return this.reportCountGranularity;
    }

    private void setReportCountGranularity(long reportCountGranularity) {
        this.reportCountGranularity = reportCountGranularity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAndReport(MetricItem metricItem) {
        if (this.reportingEnabled && metricItem.isEnabled()) {
            MetricManager metricManager = this;
            synchronized (metricManager) {
                if (this.shouldReport()) {
                    this.metricLogger.logReport();
                }
            }
        }
    }

    public void printMetricsData() {
        this.metricLogger.logReport();
    }

    private boolean getReportingEnabledConfig() {
        return this.getBooleanValue(METRICS_REPORT_ENABLED, false);
    }

    private boolean getActivityReportingConfig() {
        return this.getBooleanValue(METRICS_REPORT_ACTIVITIES, true);
    }

    private boolean getBooleanValue(String propertyName, boolean defaultValue) {
        String boolValueStr = System.getProperty(propertyName);
        boolean boolValue = boolValueStr != null ? "true".equalsIgnoreCase(boolValueStr) || !"false".equalsIgnoreCase(boolValueStr) && defaultValue : defaultValue;
        return boolValue;
    }

    private String getReportTimeConfig() {
        return System.getProperty(METRICS_REPORT_TIME_INTERVAL);
    }

    private long parseReportTime(String reportTimeStr) {
        long reportTime = 60L;
        if (reportTimeStr != null) {
            String reportTimeStr1 = reportTimeStr.toUpperCase();
            long hour = 0L;
            long minutes = 0L;
            boolean isParsed = false;
            try {
                int minsIndex;
                int hourIndex = reportTimeStr1.indexOf(72);
                if (hourIndex != -1) {
                    String temp = reportTimeStr1.substring(0, hourIndex);
                    hour = this.parseLong(temp.trim(), 0L);
                    isParsed = true;
                }
                if ((minsIndex = reportTimeStr1.indexOf(77)) != -1) {
                    String temp = reportTimeStr1.substring(hourIndex + 1, minsIndex);
                    minutes = this.parseLong(temp.trim(), 0L);
                    isParsed = true;
                }
                reportTime = isParsed ? hour * 60L + minutes : this.parseLong(reportTimeStr1, 60L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return reportTime;
    }

    private long parseLong(String longStrValue, long defaultValue) {
        long longVal;
        try {
            longVal = Long.parseLong(longStrValue);
        }
        catch (NumberFormatException e) {
            longVal = defaultValue;
        }
        return longVal;
    }

    private long getReportCountConfig() {
        String reportCountStr = System.getProperty(METRICS_REPORT_COUNT_INTERVAL);
        long reportCount = 1000L;
        if (reportCountStr != null) {
            reportCount = this.parseLong(reportCountStr, 1000L);
        }
        return reportCount;
    }

    private String getReportFormatConfig() {
        return System.getProperty(METRICS_REPORT_FORMAT);
    }

    private boolean shouldReport() {
        boolean report = false;
        if (this.reportTimeGranularity > 0L && System.currentTimeMillis() - this.lastReportedTime.getTime() >= this.reportTimeGranularity) {
            return true;
        }
        if (this.reportCountGranularity > 0L) {
            long metricCount = 0L;
            for (MetricItem metricItem : this.metricItemsList) {
                if (!metricItem.isEnabled()) continue;
                metricCount += metricItem.getMetricCount();
            }
            if (metricCount - this.lastReportedMetricCount >= this.reportCountGranularity) {
                return true;
            }
        }
        return report;
    }
}

