/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.metrics;

import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.metrics.AbstractMetricLogger;
import com.tplus.transform.runtime.metrics.MetricItem;
import com.tplus.transform.util.CalendarFormatter;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.xml.XMLWriterUtil;
import java.util.Date;

public class MetricXMLLogger
extends AbstractMetricLogger {
    protected static final Log log = LogFactory.getRuntimeLog("Stats");
    private static final String XML = "XML";
    private static final String ESCAPE_STRING = "__";
    private XMLWriterUtil xmlWriterUtil = null;
    private Log.LogLevel level = Log.INFO;
    private String metricsStartLogData = null;
    private String metricsEndLogData = null;

    public MetricXMLLogger() {
        this.reportFormat = XML;
        this.dateTimeFormat = "%Y-%M-%DT%h:%m:%s";
    }

    public void logReport() {
        Date lastReportedTime = new Date();
        this.metricManager.setLastReportedTime(lastReportedTime);
        if (this.metricsStartLogData == null) {
            this.metricsStartLogData = this.getMetricsStartLogData("VolanteMetrics-Info");
            this.metricsEndLogData = this.xmlWriterUtil.endTag("VolanteMetrics-Info");
            this.xmlWriterUtil.incrementIndent();
        }
        StringBuilder buffer = new StringBuilder(this.metricsStartLogData);
        buffer.append(this.xmlWriterUtil.tagValue("LoggedTime", CalendarFormatter.format(this.dateTimeFormat, lastReportedTime)));
        long totalMetricCount = 0L;
        for (MetricItem metricItem : this.metricManager.getMetricItemsList()) {
            if (!metricItem.isEnabled()) continue;
            long metricCount = metricItem.getMetricCount();
            totalMetricCount += metricCount;
            buffer.append(this.xmlWriterUtil.tagValue(metricItem.getName(), Long.toString(metricCount)));
        }
        this.metricManager.setLastReportedMetricCount(totalMetricCount);
        buffer.append(this.metricsEndLogData);
        String logString = buffer.toString().replaceAll(IOUtil.LINE_SEPARATOR, ESCAPE_STRING);
        log.log(logString, this.level, null);
    }

    private String getMetricsStartLogData(String parentTag) {
        StringBuilder buffer = new StringBuilder(500);
        if (this.xmlWriterUtil == null) {
            this.xmlWriterUtil = new XMLWriterUtil();
        }
        buffer.append(this.xmlWriterUtil.getXMLDecl());
        buffer.append(this.xmlWriterUtil.startTag(parentTag));
        buffer.append(this.xmlWriterUtil.tagValue("ID", this.metricManager.getSessionId()));
        buffer.append(this.xmlWriterUtil.tagValue("StartTime", CalendarFormatter.format(this.dateTimeFormat, this.metricManager.getSessionStartTime())));
        return buffer.toString();
    }

    public void logSession() {
        log.log(this.getConfigString("VolanteMetrics-SessionStart"), this.level, null);
    }

    private String getConfigString(String tag) {
        StringBuilder buffer = new StringBuilder(this.getMetricsStartLogData(tag));
        boolean reportingEnabled = this.metricManager.isReportingEnabled();
        buffer.append(this.xmlWriterUtil.tagValue("ReportingEnabled", reportingEnabled));
        if (reportingEnabled) {
            buffer.append(this.xmlWriterUtil.tagValue("ActivitiesLogEnabled", this.metricManager.isReportActivities()));
            buffer.append(this.xmlWriterUtil.tagValue("ReportCountInterval", this.getReportCountInterval()));
            buffer.append(this.xmlWriterUtil.tagValue("ReportTimeInterval", this.getFormattedReportTimeInterval()));
        }
        buffer.append(this.xmlWriterUtil.endTag(tag));
        return buffer.toString().replaceAll(IOUtil.LINE_SEPARATOR, ESCAPE_STRING);
    }

    public void logConfigChange() {
        log.log(this.getConfigString("VolanteMetrics-ConfigChanged"), this.level, null);
    }
}

