/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.persistence.expression;

import com.tplus.transform.runtime.persistence.expression.AndExpression;
import com.tplus.transform.runtime.persistence.expression.BetweenExpression;
import com.tplus.transform.runtime.persistence.expression.Conjunction;
import com.tplus.transform.runtime.persistence.expression.Disjunction;
import com.tplus.transform.runtime.persistence.expression.EqExpression;
import com.tplus.transform.runtime.persistence.expression.EqPropertyExpression;
import com.tplus.transform.runtime.persistence.expression.GeExpression;
import com.tplus.transform.runtime.persistence.expression.GtExpression;
import com.tplus.transform.runtime.persistence.expression.InExpression;
import com.tplus.transform.runtime.persistence.expression.LeExpression;
import com.tplus.transform.runtime.persistence.expression.LePropertyExpression;
import com.tplus.transform.runtime.persistence.expression.LikeExpression;
import com.tplus.transform.runtime.persistence.expression.LtExpression;
import com.tplus.transform.runtime.persistence.expression.LtPropertyExpression;
import com.tplus.transform.runtime.persistence.expression.NotExpression;
import com.tplus.transform.runtime.persistence.expression.NotNullExpression;
import com.tplus.transform.runtime.persistence.expression.NullExpression;
import com.tplus.transform.runtime.persistence.expression.OrExpression;
import com.tplus.transform.runtime.persistence.expression.SQLExpression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public abstract class Expression
implements Serializable {
    protected static final Object[] NO_OBJECTS = new Object[0];
    protected static final String[] NO_COLUMNS = new String[0];

    public static Expression eq(String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        return new EqExpression(propertyName, value);
    }

    public static Expression eqIgnoreNull(String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        return new EqExpression(propertyName, value);
    }

    public static Expression like(String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        return new LikeExpression(propertyName, value);
    }

    public static Expression gt(String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        return new GtExpression(propertyName, value);
    }

    public static Expression lt(String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        return new LtExpression(propertyName, value);
    }

    public static Expression le(String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        return new LeExpression(propertyName, value);
    }

    public static Expression ge(String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        return new GeExpression(propertyName, value);
    }

    public static Expression between(String propertyName, Object lo, Object hi) {
        if (lo == null && hi == null) {
            return null;
        }
        if (lo == null) {
            return Expression.le(propertyName, hi);
        }
        if (hi == null) {
            return Expression.ge(propertyName, lo);
        }
        return new BetweenExpression(propertyName, lo, hi);
    }

    public static Expression in(String propertyName, Object[] values) {
        ArrayList<Object> objList = new ArrayList<Object>();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value == null) continue;
            objList.add(value);
        }
        values = objList.toArray(new Object[objList.size()]);
        if (values.length > 0) {
            return new InExpression(propertyName, values);
        }
        return null;
    }

    public static Expression in(String propertyName, Collection values) {
        return new InExpression(propertyName, values.toArray());
    }

    public static Expression isNull(String propertyName) {
        return new NullExpression(propertyName);
    }

    public static Expression eqProperty(String propertyName, String otherPropertyName) {
        return new EqPropertyExpression(propertyName, otherPropertyName);
    }

    public static Expression ltProperty(String propertyName, String otherPropertyName) {
        return new LtPropertyExpression(propertyName, otherPropertyName);
    }

    public static Expression leProperty(String propertyName, String otherPropertyName) {
        return new LePropertyExpression(propertyName, otherPropertyName);
    }

    public static Expression isNotNull(String propertyName) {
        return new NotNullExpression(propertyName);
    }

    public static Expression and(Expression lhs, Expression rhs) {
        if (lhs == null && rhs == null) {
            return null;
        }
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        return new AndExpression(lhs, rhs);
    }

    public static Expression or(Expression lhs, Expression rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        return new OrExpression(lhs, rhs);
    }

    public static Expression not(Expression expression) {
        if (expression == null) {
            return null;
        }
        return new NotExpression(expression);
    }

    public static Expression sql(String sql, Object[] values) {
        return new SQLExpression(sql, values, new String[values.length]);
    }

    public static Expression sql(String sql, Object value) {
        return new SQLExpression(sql, new Object[]{value}, new String[]{"Col"});
    }

    public static Expression sql(String sql) {
        return new SQLExpression(sql, NO_OBJECTS, NO_COLUMNS);
    }

    public static Conjunction conjunction() {
        return new Conjunction();
    }

    public static Disjunction disjunction() {
        return new Disjunction();
    }

    public static Expression allEq(Map propertyNameValues) {
        Conjunction conj = Expression.conjunction();
        for (Map.Entry me : propertyNameValues.entrySet()) {
            conj.add(Expression.eq((String)me.getKey(), me.getValue()));
        }
        return conj;
    }

    public abstract String toSqlString();

    public abstract String[] getColumns();

    public abstract Object[] getValues();

    public abstract String toString();
}

