/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.persistence.expression;

import com.tplus.transform.runtime.persistence.expression.Expression;
import com.tplus.transform.util.sql.StringHelper;

public class InExpression
extends Expression {
    private final String propertyName;
    private final Object[] values;

    InExpression(String propertyName, Object[] values) {
        this.propertyName = propertyName;
        this.values = values;
    }

    public String toSqlString() {
        String params = StringHelper.repeat("?, ", this.values.length - 1);
        if (this.values.length > 0) {
            params = params + "?";
        }
        String condition = " in (" + params + ')';
        return StringHelper.join(" and ", StringHelper.suffix(this.getColumns(), condition));
    }

    public String[] getColumns() {
        return new String[]{this.propertyName};
    }

    public Object[] getValues() {
        return this.values;
    }

    public String toString() {
        return this.propertyName + " in (" + StringHelper.toString(this.values) + ')';
    }
}

