/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.persistence.expression;

import com.tplus.transform.runtime.persistence.expression.Expression;

public abstract class LogicalExpression
extends Expression {
    protected Expression lhs;
    protected Expression rhs;

    LogicalExpression(Expression lhs, Expression rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public String[] getColumns() {
        String[] lhstv = this.lhs.getColumns();
        String[] rhstv = this.rhs.getColumns();
        String[] result = new String[lhstv.length + rhstv.length];
        System.arraycopy(lhstv, 0, result, 0, lhstv.length);
        System.arraycopy(rhstv, 0, result, lhstv.length, rhstv.length);
        return result;
    }

    public Object[] getValues() {
        Object[] lhstv = this.lhs.getValues();
        Object[] rhstv = this.rhs.getValues();
        Object[] result = new Object[lhstv.length + rhstv.length];
        System.arraycopy(lhstv, 0, result, 0, lhstv.length);
        System.arraycopy(rhstv, 0, result, lhstv.length, rhstv.length);
        return result;
    }

    public String toSqlString() {
        return '(' + this.lhs.toSqlString() + ' ' + this.getOp() + ' ' + this.rhs.toSqlString() + ')';
    }

    abstract String getOp();

    public String toString() {
        return this.lhs.toString() + ' ' + this.getOp() + ' ' + this.rhs.toString();
    }
}

