/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.pojo;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class BeanFactory {
    Map beanInfos = new HashMap();

    BeanInfo getBeanInfo(DataObject data) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        BeanInfo info;
        if (data instanceof ExternalObject) {
            ExternalObject externalObject = (ExternalObject)data;
            String className = externalObject.getData().getClass().getName();
            info = (BeanInfo)this.beanInfos.get(className);
            if (info == null) {
                int lastDot = className.lastIndexOf(46);
                String packageName = className.substring(0, lastDot);
                className = className.substring(lastDot + 1);
                String beanClassName = packageName + "." + StringUtils.leftStr(className, "RecordData") + "Bean";
                Class<?> beanClass = Class.forName(beanClassName);
                Constructor<?> constructor = beanClass.getConstructor(ExternalObject.class);
                info = new BeanInfo(constructor);
                this.beanInfos.put(beanClassName, info);
            }
        } else {
            String className = data.getClass().getName();
            info = (BeanInfo)this.beanInfos.get(className);
            if (info == null) {
                int lastDot = className.lastIndexOf(46);
                String packageName = className.substring(0, lastDot);
                className = className.substring(lastDot + 1);
                String beanClassName = packageName + "." + className + "Bean";
                Class<?> beanClass = Class.forName(beanClassName);
                Constructor<?> constructor = beanClass.getConstructor(DataObject.class);
                info = new BeanInfo(constructor);
                this.beanInfos.put(beanClassName, info);
            }
        }
        return info;
    }

    public Object createBean(DataObject obj) throws InvocationTargetException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        BeanInfo beanInfo = this.getBeanInfo(obj);
        Object bean = beanInfo.newInstance(obj);
        return bean;
    }

    static class BeanInfo {
        Constructor constructor;

        BeanInfo(Constructor constructor) {
            this.constructor = constructor;
        }

        Object newInstance(DataObject obj) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            return this.constructor.newInstance(obj);
        }
    }
}

