/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.simple;

import com.tplus.transform.runtime.BatchContext;
import com.tplus.transform.runtime.BatchMessage;
import com.tplus.transform.runtime.BusinessTransaction;
import com.tplus.transform.runtime.ExternalMessage;
import com.tplus.transform.runtime.InputFormat;
import com.tplus.transform.runtime.InternalMessage;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.LookupContextFactory;
import com.tplus.transform.runtime.Message;
import com.tplus.transform.runtime.MessageFlow;
import com.tplus.transform.runtime.MessageMapping;
import com.tplus.transform.runtime.MessageValidation;
import com.tplus.transform.runtime.NormalizedObjectMappingFormat;
import com.tplus.transform.runtime.OutputContext;
import com.tplus.transform.runtime.OutputFormat;
import com.tplus.transform.runtime.OutputProtocol;
import com.tplus.transform.runtime.PersistenceManager;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.factory.CreateException;
import com.tplus.transform.runtime.factory.RuntimeElementFactory;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.simple.Bindings;
import com.tplus.transform.runtime.simple.SimpleResource;
import com.tplus.transform.runtime.simple.SimpleServer;
import com.tplus.transform.util.ArrayUtils;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.sql.connection.ConnectionPool;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.NamingException;

public class LookupContextSimpleImpl
implements LookupContext {
    protected static Log log = LogFactory.getRuntimeLog("simplert");
    private static final String BATCH_CONTEXT_HOME = "batchcontext";
    private static final String OUTPUT_CONTEXT_HOME = "outputcontext";
    boolean pooled;
    private static final String TRANSACTION_MANAGER_LOCATION = "TransactionManager";

    public LookupContextSimpleImpl() throws NamingException {
        this.pooled = true;
    }

    public LookupContextSimpleImpl(boolean pooled) throws NamingException {
        this.pooled = pooled;
    }

    public LookupContextSimpleImpl(Hashtable props) throws NamingException {
    }

    public Object lookup(String name) throws NamingException {
        Object obj = this.getBindings().get(name);
        if (obj == null) {
            throw SimpleResource.createNamingExceptionFormatted("SIM109", name);
        }
        return obj;
    }

    public Object lookup(String name, String typeName) throws NamingException {
        Object obj = this.getBindings().get(name);
        if (obj == null) {
            throw SimpleResource.createNamingExceptionFormatted("SIM109", new String[]{name, typeName});
        }
        return obj;
    }

    private Bindings getBindings() {
        return SimpleServer.getInstance().getBindings();
    }

    private Object lookupRuntimeElementFactoryObject(String name, Class type) throws NamingException {
        String typeName = StringUtils.lastRightStr(type.getName(), ".");
        Object o = this.lookup(name, typeName = StringUtils.toDisplayName(typeName));
        if (o instanceof RuntimeElementFactory) {
            RuntimeElementFactory factory = (RuntimeElementFactory)o;
            try {
                Object remote = factory.create(this.pooled);
                if (type.isInstance(remote)) {
                    return remote;
                }
            }
            catch (RemoteException e) {
                throw new NamingException(e.getMessage());
            }
            catch (CreateException e) {
                throw new NamingException(e.getMessage());
            }
            catch (Exception e) {
                throw SimpleResource.createNamingExceptionFormatted("SIM110", e.getMessage());
            }
            throw SimpleResource.createNamingExceptionFormatted("SIM109A", new String[]{name, typeName});
        }
        throw SimpleResource.createNamingExceptionFormatted("SIM109A", new String[]{name, typeName});
    }

    private RuntimeElementFactory lookupRuntimeElementFactoryOrNull(String name) throws NamingException {
        Object obj = this.getBindings().get(name);
        if (obj instanceof RuntimeElementFactory) {
            return (RuntimeElementFactory)obj;
        }
        return null;
    }

    public InputFormat lookupInputFormat(String name) throws NamingException {
        return (InputFormat)this.lookupRuntimeElementFactoryObject(name, InputFormat.class);
    }

    public OutputFormat lookupOutputFormat(String name) throws NamingException {
        return (OutputFormat)this.lookupRuntimeElementFactoryObject(name, OutputFormat.class);
    }

    public MessageFlow lookupMessageFlow(String name) throws NamingException {
        return (MessageFlow)this.lookupRuntimeElementFactoryObject(name, MessageFlow.class);
    }

    public Object lookupElement(String name, Class cls) throws NamingException {
        return this.lookupRuntimeElementFactoryObject(name, cls);
    }

    public NormalizedObjectMappingFormat lookupNormalizedObjectMappingFormat(String name) throws NamingException {
        return (NormalizedObjectMappingFormat)this.lookupRuntimeElementFactoryObject(name, NormalizedObjectMappingFormat.class);
    }

    public MessageValidation lookupValidation(String name) throws NamingException {
        return (MessageValidation)this.lookupRuntimeElementFactoryObject(name, MessageValidation.class);
    }

    public Message lookupMessage(String name) throws NamingException {
        return (Message)this.lookupRuntimeElementFactoryObject(name, Message.class);
    }

    public BusinessTransaction lookupBusinessTransaction(String name) throws NamingException {
        return (BusinessTransaction)this.lookupRuntimeElementFactoryObject(name, BusinessTransaction.class);
    }

    public ExternalMessage lookupExternalMessage(String name) throws NamingException {
        return (ExternalMessage)this.lookupRuntimeElementFactoryObject(name, ExternalMessage.class);
    }

    public BatchMessage lookupBatchMessage(String name) throws NamingException {
        return (BatchMessage)this.lookupRuntimeElementFactoryObject(name, BatchMessage.class);
    }

    public InternalMessage lookupInternalMessage(String name) throws NamingException {
        return this.lookupBusinessTransaction(name);
    }

    public MessageMapping lookupMessageMapping(String name) throws NamingException {
        return (MessageMapping)this.lookupRuntimeElementFactoryObject(name, MessageMapping.class);
    }

    public PersistenceManager lookupPersistenceManager(String name) throws NamingException {
        return (PersistenceManager)this.lookupRuntimeElementFactoryObject(name, PersistenceManager.class);
    }

    public Object lookupComponent(String name) throws NamingException {
        return this.lookup(name);
    }

    public OutputProtocol lookupOutputProtocol(String name) throws NamingException {
        String protocolName = LookupContextFactory.fixProtocolName(name);
        return (OutputProtocol)this.lookupRuntimeElementFactoryObject(protocolName, OutputProtocol.class);
    }

    public OutputProtocol lookupOutputProtocol2(String name) throws NamingException {
        return this.lookupOutputProtocol(name);
    }

    public BatchContext createBatchContext() throws NamingException {
        return (BatchContext)this.lookupRuntimeElementFactoryObject(BATCH_CONTEXT_HOME, BatchContext.class);
    }

    public void destroyBatchContext(BatchContext bc) throws TransformException, RemoteException, NamingException {
        bc.endBatch();
    }

    public OutputContext createOutputContext() throws NamingException {
        return (OutputContext)this.lookupRuntimeElementFactoryObject(OUTPUT_CONTEXT_HOME, OutputContext.class);
    }

    public void destroyOutputContext(OutputContext bc) throws TransformException, RemoteException, NamingException {
    }

    public void bind(String name, Object obj) throws NamingException {
        Bindings cxt = this.getBindings();
        if (cxt.get(name) != null) {
            throw SimpleResource.createNamingExceptionFormatted("SIM117", name);
        }
        cxt.put(name, obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        Bindings cxt = this.getBindings();
        cxt.put(name, obj);
    }

    public void unbind(String name) throws NamingException {
        Bindings cxt = this.getBindings();
        cxt.remove(name);
    }

    public Object getTransactionManager() throws NamingException {
        Bindings cxt = this.getBindings();
        return cxt.get(TRANSACTION_MANAGER_LOCATION);
    }

    public Object lookupUserTransaction() throws NamingException {
        Bindings cxt = this.getBindings();
        Object o = cxt.get(TRANSACTION_MANAGER_LOCATION);
        return o;
    }

    public ConnectionPool lookupDataSource(String name) throws RemoteException, NamingException {
        return (ConnectionPool)this.lookup(name);
    }

    public String[] getInternalMessages() throws NamingException {
        return this.getContextBindings(InternalMessage.class);
    }

    public String[] getExternalMessages() throws NamingException {
        return this.getContextBindings(ExternalMessage.class);
    }

    public String[] getMessages() throws NamingException {
        return (String[])ArrayUtils.add(this.getExternalMessages(), this.getInternalMessages());
    }

    public String[] getBatchMessages() throws NamingException {
        return this.getContextBindings(BatchMessage.class);
    }

    public String[] getInputFormats() throws NamingException {
        return this.getContextBindings(InputFormat.class);
    }

    public String[] getOutputFormats() throws NamingException {
        return this.getContextBindings(OutputFormat.class);
    }

    public String[] getNormalizedObjectMappings() throws NamingException {
        return this.getContextBindings(NormalizedObjectMappingFormat.class);
    }

    public String[] getMessageFlows() throws NamingException {
        return this.getContextBindings(MessageFlow.class);
    }

    public String[] getMessageMappings() throws NamingException {
        return this.getContextBindings(MessageMapping.class);
    }

    String[] getContextBindings(Class cls) throws NamingException {
        Bindings cxt = this.getBindings();
        ArrayList<String> boundNames = new ArrayList<String>();
        Set set = cxt.names();
        for (String lookupName : set) {
            Object value = cxt.get(lookupName);
            if (!(value instanceof RuntimeElementFactory)) continue;
            RuntimeElementFactory factory = (RuntimeElementFactory)value;
            try {
                if (cls == null || !cls.isAssignableFrom(factory.getInterfaceClass())) continue;
                boundNames.add(lookupName);
            }
            catch (RemoteException e) {}
        }
        return boundNames.toArray(new String[boundNames.size()]);
    }
}

