/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.simple;

import com.tplus.transform.runtime.StandardRuntimeResource;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformNestableException;
import com.tplus.transform.runtime.factory.CreateException;
import com.tplus.transform.runtime.simple.SimpleServerException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.naming.NamingException;

public class SimpleResource {
    static Map resourceBundles = new HashMap();

    static ResourceBundle getResourceBundle(Class cls) {
        String packageName = SimpleResource.getPackageName(cls);
        return SimpleResource.getResourceBundle(packageName, cls.getClassLoader());
    }

    static ResourceBundle getResourceBundle(String packageName, ClassLoader loader) {
        ResourceBundle rsrc = (ResourceBundle)resourceBundles.get(packageName);
        if (rsrc == null) {
            rsrc = ResourceBundle.getBundle(packageName + ".message", Locale.getDefault(), loader);
            resourceBundles.put(packageName, rsrc);
        }
        return rsrc;
    }

    public static String getMessage(Class cls, String messageId) {
        ResourceBundle rsrc = SimpleResource.getResourceBundle(cls);
        String message = rsrc.getString(messageId + ".message");
        return message;
    }

    public static String getErrorCode(Class cls, String messageId) {
        ResourceBundle rsrc = SimpleResource.getResourceBundle(cls);
        String code = rsrc.getString(messageId + ".code");
        return code;
    }

    static String getFormattedMessage(Class cls, String messageId, Object[] args) {
        String messageTemplate = SimpleResource.getMessage(cls, messageId);
        String message = "Unknown Error";
        if (messageTemplate != null) {
            message = MessageFormat.format(messageTemplate, args);
        }
        return message;
    }

    public static CreateException createCreateExceptionFormatted(String messageId, Throwable e) {
        return SimpleResource.createCreateExceptionFormatted(messageId, new Object[0], e);
    }

    public static CreateException createCreateExceptionFormatted(String messageId, Object[] args, Throwable e) {
        String message = SimpleResource.getFormattedMessage(SimpleResource.class, messageId, args);
        return new CreateException(message, e);
    }

    public static SimpleServerException createSimpleExceptionFormatted(String messageId, Throwable e) {
        return SimpleResource.createSimpleExceptionFormatted(messageId, new Object[0], e);
    }

    public static SimpleServerException createSimpleExceptionFormatted(String messageId, Object[] args, Throwable e) {
        String message = SimpleResource.getFormattedMessage(SimpleResource.class, messageId, args);
        return new SimpleServerException(message, e);
    }

    public static NamingException createNamingExceptionFormatted(String messageId) {
        return SimpleResource.createNamingExceptionFormatted(messageId, new Object[0]);
    }

    public static NamingException createNamingExceptionFormatted(String messageId, String arg) {
        return SimpleResource.createNamingExceptionFormatted(messageId, new Object[]{arg});
    }

    public static NamingException createNamingExceptionFormatted(String messageId, Object[] args) {
        String message = SimpleResource.getFormattedMessage(SimpleResource.class, messageId, args);
        return new NamingException(message);
    }

    public static TransformException createFormatted(Class exceptionClass, String messageId) {
        return SimpleResource.createFormatted(exceptionClass, messageId, new Object[0]);
    }

    public static TransformException createFormatted(Class exceptionClass, String messageId, String arg) {
        return SimpleResource.createFormatted(exceptionClass, messageId, new Object[]{arg});
    }

    public static TransformException createFormatted(Class exceptionClass, String messageId, Object[] args) {
        String message = SimpleResource.getFormattedMessage(SimpleResource.class, messageId, args);
        String errorCode = SimpleResource.getErrorCode(SimpleResource.class, messageId);
        TransformNestableException e = StandardRuntimeResource.create(exceptionClass, message, errorCode);
        e.setContextProperty("Internal-Code", messageId);
        return (TransformException)e;
    }

    private static String getPackageName(Class cls) {
        String className = cls.getName();
        String packageName = SimpleResource.getPackageName(className);
        return packageName;
    }

    private static String getPackageName(String className) {
        String packageName = className.substring(0, className.lastIndexOf(46));
        return packageName;
    }
}

