/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.simple;

import com.tplus.license.LicenseException;
import com.tplus.license.RuntimeLicenseVerifierSingleton;
import com.tplus.transform.lang.CallListener;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.mail.MailInfo;
import com.tplus.transform.runtime.mail.SMTPHelper;
import com.tplus.transform.runtime.simple.Bindings;
import com.tplus.transform.runtime.simple.LookupContextSimpleImpl;
import com.tplus.transform.runtime.simple.SimpleResource;
import com.tplus.transform.runtime.simple.SimpleServerException;
import com.tplus.transform.runtime.simple.SimpleServerInfo;
import com.tplus.transform.runtime.simple.TransactionInfo;
import com.tplus.transform.runtime.simple.factory.RuntimeElementFactorySimple;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.SequencedHashMap;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import com.tplus.transform.util.sql.connection.ConnectionInfo;
import com.tplus.transform.util.sql.connection.ConnectionPool;
import com.tplus.transform.util.xml.XMLUtils;
import com.volante.component.server.jdbc.RequiresTransactionManager;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SimpleServer {
    public static final String TRANSACTION_MANAGER_LOCATION = "TransactionManager";
    protected static Log log = LogFactory.getLog(SimpleServer.class, "volante.runtime.simplert");
    public static final String RUNTIME_ELEMENT_TAG = "RuntimeElement";
    protected static final String CLASS_TAG = "Class";
    protected static final String INTERFACE_TAG = "Interface";
    protected static final String NAME_TAG = "name";
    public static final String TPLUS_RUNTIME_FILE = "tplus-jar.xml";
    public static final String DATA_SOURCES_FILE_OLD = "data-sources.xml";
    public static final String MAIL_SOURCES_FILE = "mail-sources.xml";
    public static final String DATA_SOURCES_FILE = "volante-data-sources.xml";
    private static final String ALWAYS_POOL_TAG = "always-pool";
    public static final String RUNTIME_MANIFEST = "MANIFEST.MF";
    byte[] tplusDTDData;
    DocumentBuilder docBuilder;
    Bindings bindings = new Bindings();
    private List elementFactories = new ArrayList();
    private TransactionManager transactionManager;
    LookupContext cxt;
    SimpleServerInfo serverInfo;
    Map connectionPools = new SequencedHashMap();
    Map mailSources = new SequencedHashMap();
    static SimpleServer instance;

    public static void initFromClasspath() throws SimpleServerException {
        try {
            SimpleServer simpleServer;
            instance = simpleServer = new SimpleServer();
            simpleServer.init();
            simpleServer.startServer();
        }
        catch (NamingException e) {
            throw SimpleResource.createSimpleExceptionFormatted("SIM101", e);
        }
    }

    public void applyResourceReferences(Map references) throws NamingException {
        for (Map.Entry entry : references.entrySet()) {
            String appResourceName = (String)entry.getKey();
            String serverResourceName = (String)entry.getValue();
            try {
                Object resource = this.cxt.lookup(serverResourceName);
                this.cxt.rebind(appResourceName, resource);
                log.info("Binding server resource " + serverResourceName + " as " + appResourceName);
            }
            catch (NamingException e) {
                log.error("Error Binding server resource " + serverResourceName + " as " + appResourceName, e);
            }
        }
    }

    public static SimpleServer getInstance() {
        if (instance == null) {
            try {
                log.info("Starting Simple runtime ...");
                SimpleServer.initFromClasspath();
            }
            catch (SimpleServerException e) {
                log.error("Error starting simple server ", e);
            }
        }
        return instance;
    }

    SimpleServer() throws NamingException {
    }

    void init() throws NamingException {
        this.bindings.unbindAll();
        LookupContextSimpleImpl lookupContextSimple = new LookupContextSimpleImpl();
        this.cxt = lookupContextSimple;
    }

    public void stop() {
        log.info("Stopping application");
        this.bindings.unbindAll();
        this.elementFactories.clear();
        for (Map.Entry entry : this.connectionPools.entrySet()) {
            String key = (String)entry.getKey();
            ConnectionPool connectionPool = (ConnectionPool)entry.getValue();
            try {
                connectionPool.closeAllConnections();
            }
            catch (SQLException e) {}
        }
        this.connectionPools.clear();
        if (instance == this) {
            instance = null;
        }
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public List getElementFactories() {
        return this.elementFactories;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public Collection getConnectionPools() {
        return this.connectionPools.values();
    }

    void startServer() throws SimpleServerException {
        this.serverInfo = new SimpleServerInfo();
        this.startTransactionManager();
        this.readMailSourceFiles();
        this.createMailSources(this.serverInfo);
        try {
            this.loadTplusJars();
        }
        catch (IOException e) {
            throw SimpleResource.createSimpleExceptionFormatted("SIM102", e);
        }
        long runtimeLicenseCheckStartTime = System.currentTimeMillis();
        long runtimeLicenseCheckEndTime = 0L;
        try {
            boolean validLicense = this.checkAndLoadRuntimeLicenses();
            if (!validLicense) {
                log.error("Execution Aborted - INVALID VOLANTE RUNTIME LICENSE.");
                this.stop();
                throw new LicenseException("Volante Runtime License file is either invalid, or not available. Please check with your administrator to proceed further:");
            }
        }
        catch (Exception e) {
            this.stop();
            log.error("Volante - SimpleRuntime - is stopped because there is no valid license jar. ");
            throw SimpleResource.createSimpleExceptionFormatted("SIM123", e);
        }
        finally {
            runtimeLicenseCheckEndTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readVolanteXML(URL url) throws SimpleServerException {
        try {
            URLConnection jarConnection = url.openConnection();
            jarConnection.connect();
            InputStream is = jarConnection.getInputStream();
            try {
                BufferedInputStream bis = new BufferedInputStream(is);
                byte[] bytes = IOUtil.readStream(bis);
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                this.readVolanteXML(bais);
            }
            catch (Exception e) {
                log.error("Error reading tplus-jar.xml " + url, e);
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            log.warn("Error reading " + url + ". " + e.getMessage());
            log.debug("Stack trace ", e);
        }
    }

    public void readVolanteXML(InputStream is) throws SimpleServerException {
        Document doc = null;
        try {
            DocumentBuilder docBuilder = this.createDocumentBuilder();
            docBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) {
                    if (systemId.startsWith("http://java.tplussys.com/dtds")) {
                        return new InputSource(new StringReader(""));
                    }
                    return null;
                }
            });
            doc = docBuilder.parse(is);
        }
        catch (IOException err) {
            throw SimpleResource.createSimpleExceptionFormatted("SIM103", err);
        }
        catch (ParserConfigurationException err) {
            throw SimpleResource.createSimpleExceptionFormatted("SIM103", err);
        }
        catch (SAXParseException err) {
            throw SimpleResource.createSimpleExceptionFormatted("SIM103", err);
        }
        catch (SAXException e) {
            Exception x = e.getException();
            throw SimpleResource.createSimpleExceptionFormatted("SIM104", x == null ? e : x);
        }
        this.readXMLDocument(doc);
    }

    private InputStream getTplusDTD() throws IOException {
        if (this.tplusDTDData != null) {
            InputStream resourceAsStream = SimpleServer.class.getResourceAsStream("tplus-jar.dtd");
            this.tplusDTDData = IOUtil.readStream(resourceAsStream);
        }
        return new ByteArrayInputStream(this.tplusDTDData);
    }

    private synchronized DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        if (this.docBuilder == null) {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setValidating(false);
            this.docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        return this.docBuilder;
    }

    public void addCallListener(CallListener callListener) {
        for (int i = 0; i < this.elementFactories.size(); ++i) {
            RuntimeElementFactorySimple runtimeElementFactory = (RuntimeElementFactorySimple)this.elementFactories.get(i);
            runtimeElementFactory.addCallListener(callListener);
        }
    }

    public void removeCallListener(CallListener callListener) {
        for (int i = 0; i < this.elementFactories.size(); ++i) {
            RuntimeElementFactorySimple runtimeElementFactory = (RuntimeElementFactorySimple)this.elementFactories.get(i);
            runtimeElementFactory.removeCallListener(callListener);
        }
    }

    public void readXMLDocument(Document doc) throws SimpleServerException {
        this.readElements(doc);
    }

    void readElements(Document doc) throws SimpleServerException {
        Element rootElm = doc.getDocumentElement();
        NodeList runtimeList = rootElm.getElementsByTagName(RUNTIME_ELEMENT_TAG);
        for (int i = 0; i < runtimeList.getLength(); ++i) {
            try {
                Element runtimeElm = (Element)runtimeList.item(i);
                String name = XMLUtils.getSingleChildElementValue(runtimeElm, NAME_TAG);
                String className = XMLUtils.getSingleChildElementValue(runtimeElm, CLASS_TAG);
                String interfaceName = XMLUtils.getSingleChildElementValue(runtimeElm, INTERFACE_TAG);
                boolean alwaysPool = Boolean.valueOf(XMLUtils.getSingleChildElementValue(runtimeElm, ALWAYS_POOL_TAG));
                Class<?> implClass = Class.forName(className);
                Class<?> interfaceClass = Class.forName(interfaceName);
                RuntimeElementFactorySimple elementFactory = new RuntimeElementFactorySimple(name, implClass, interfaceClass, alwaysPool);
                this.cxt.rebind(name, elementFactory);
                this.elementFactories.add(elementFactory);
                log.trace("Binding " + className + " as '" + name + "'");
                continue;
            }
            catch (Throwable t) {
                throw SimpleResource.createSimpleExceptionFormatted("SIM105", t);
            }
        }
    }

    public void enableProfiler() {
    }

    private void loadTplusJars() throws IOException, SimpleServerException {
        Enumeration<URL> resources = SimpleServer.class.getClassLoader().getResources("META-INF/tplus-jar.xml");
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            log.debug("Loading resource " + url);
            this.readVolanteXML(url);
        }
    }

    void startTransactionManager() throws SimpleServerException {
        this.readDataSourceFiles();
        try {
            TransactionInfo info = this.serverInfo.getTransactionInfo();
            this.transactionManager = info.getTransactionManager();
            this.cxt.rebind(TRANSACTION_MANAGER_LOCATION, this.transactionManager);
            this.createDataSources(this.serverInfo);
        }
        catch (Exception e) {
            throw SimpleResource.createSimpleExceptionFormatted("SIM106", e);
        }
    }

    void readDataSourceFiles() throws SimpleServerException {
        try {
            this.loadDataSourceResources(DATA_SOURCES_FILE, this.serverInfo);
            this.loadDataSourceResources(DATA_SOURCES_FILE_OLD, this.serverInfo);
        }
        catch (Throwable t) {
            throw SimpleResource.createSimpleExceptionFormatted("SIM107", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataSourceResources(String resourceName, SimpleServerInfo serverInfo) throws Exception {
        Enumeration<URL> resources = SimpleServer.class.getClassLoader().getResources(resourceName);
        boolean first = true;
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            log.debug("Loading resource " + url);
            URLConnection connection = url.openConnection();
            InputStream is = connection.getInputStream();
            try {
                serverInfo.readDataSources(is, first);
            }
            finally {
                is.close();
            }
            first = false;
        }
    }

    void createDataSources(SimpleServerInfo serverInfo) throws SimpleServerException {
        List dataSources = serverInfo.getDataSources();
        for (int i = 0; i < dataSources.size(); ++i) {
            ConnectionInfo connectionInfo = (ConnectionInfo)dataSources.get(i);
            if (!StringUtils.isEmpty(connectionInfo.getDbType())) continue;
            this.addDataSource(connectionInfo);
        }
        Map serverResources = this.connectionPools;
        Iterator it = serverResources.keySet().iterator();
        while (it.hasNext()) {
            try {
                String resourceName = (String)it.next();
                Object resource = serverResources.get(resourceName);
                this.cxt.rebind(resourceName, resource);
                if (!(resource instanceof RequiresTransactionManager)) continue;
                RequiresTransactionManager managedConnectionPool = (RequiresTransactionManager)resource;
                managedConnectionPool.setTransactionManager(this.transactionManager);
            }
            catch (NamingException e) {
                throw SimpleResource.createSimpleExceptionFormatted("SIM108", e);
            }
        }
    }

    public void addDataSource(ConnectionInfo connectionInfo) {
        String location = connectionInfo.getProperty("location");
        String className = connectionInfo.getProperty("class");
        if (className == null || className.length() == 0) {
            log.error("Class name not specified for datasource '" + connectionInfo.getName() + "'. ");
        }
        try {
            Class<?> cls = Class.forName(className);
            ConnectionPool cp = (ConnectionPool)cls.newInstance();
            try {
                cp.init(connectionInfo);
                log.info("Started data source at server location:" + location);
            }
            catch (Throwable t) {
                log.warn("Failed to start datasource at server location '" + location + "'. " + t.getClass().getName() + ":" + t.getMessage());
                log.debug("Stack Trace", t);
            }
            this.connectionPools.put(location, cp);
        }
        catch (Throwable t) {
            log.error("Failed to start data source at " + location + ". " + t.getMessage() + ". class = " + className);
            t.printStackTrace();
            log.debug("Stack trace:", t);
        }
    }

    void readMailSourceFiles() throws SimpleServerException {
        try {
            this.loadMailResources(MAIL_SOURCES_FILE, this.serverInfo);
        }
        catch (Throwable t) {
            throw SimpleResource.createSimpleExceptionFormatted("SIM107", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMailResources(String resourceName, SimpleServerInfo serverInfo) throws Exception {
        Enumeration<URL> resources = SimpleServer.class.getClassLoader().getResources(resourceName);
        boolean first = true;
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            log.debug("Loading resource " + url);
            URLConnection connection = url.openConnection();
            InputStream is = connection.getInputStream();
            try {
                serverInfo.readMailSources(is);
            }
            finally {
                is.close();
            }
            first = false;
        }
    }

    void createMailSources(SimpleServerInfo serverInfo) throws SimpleServerException {
        List mailInfos = serverInfo.getMailSources();
        for (int i = 0; i < mailInfos.size(); ++i) {
            MailInfo connectionInfo = (MailInfo)mailInfos.get(i);
            this.addMailSource(connectionInfo);
        }
        Map serverResources = this.mailSources;
        Iterator it = serverResources.keySet().iterator();
        while (it.hasNext()) {
            try {
                String resourceName = (String)it.next();
                Object resource = serverResources.get(resourceName);
                this.cxt.rebind(resourceName, resource);
            }
            catch (NamingException e) {
                throw SimpleResource.createSimpleExceptionFormatted("SIM108", e);
            }
        }
    }

    public void addMailSource(MailInfo mailInfo) {
        SMTPHelper smtpHelper = new SMTPHelper();
        smtpHelper.init(mailInfo.getProperties());
        String location = mailInfo.getProperty("location");
        try {
            this.mailSources.put(location, smtpHelper);
        }
        catch (Throwable t) {
            log.error("Failed to start mail source at " + location + ". " + t.getMessage());
            t.printStackTrace();
            log.debug("Stack trace:", t);
        }
    }

    private boolean checkAndLoadRuntimeLicenses() throws IOException, SimpleServerException {
        boolean isValidLicense = false;
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            ClassLoader parentClassLoader = classLoader.getClass().getClassLoader();
            if (parentClassLoader != null && parentClassLoader.getClass().getName().equals("com.tplus.transform.design.app.DesignerHomeLoader$VolanteHomeClassLoader")) {
                isValidLicense = true;
            } else {
                RuntimeLicenseVerifierSingleton.getInstance();
                isValidLicense = RuntimeLicenseVerifierSingleton.isRuntimeLicenseValid();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw SimpleResource.createSimpleExceptionFormatted("SIM122", t);
        }
        return isValidLicense;
    }
}

