/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.simple;

import com.tplus.transform.runtime.mail.MailInfo;
import com.tplus.transform.runtime.simple.SimpleResource;
import com.tplus.transform.runtime.simple.SimpleServerException;
import com.tplus.transform.runtime.simple.TransactionInfo;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.sql.SchemaException;
import com.tplus.transform.util.sql.connection.ConnectionInfo;
import com.tplus.transform.util.sql.connection.ConnectionInfoList;
import com.tplus.transform.util.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class SimpleServerInfo
implements Serializable {
    public static final String DATA_SOURCE_TAG = "data-source";
    public static final String DATA_SOURCES_TAG = "data-sources";
    public static final String TRANSACTION_MANAGER_PROVIDER = "transaction-manager-provider";
    public static final String NAME_ATTRIB = "name";
    public static final String VALUE_ATTRIB = "value";
    public static final String MAIL_SOURCE_TAG = "mail-source";
    public static final String MAIL_SOURCES_TAG = "mail-sources";
    public static final String PROPERTY_TAG = "property";
    boolean configureLogger = true;
    List dataSources = new ArrayList();
    List mailSources = new ArrayList();
    TransactionInfo transactionInfo = new TransactionInfo("com.volante.component.server.transaction.TransactionManagerImpl", null, new Properties());

    public void setConfigureLogger(boolean configureLogger) {
        this.configureLogger = configureLogger;
    }

    public boolean getConfigureLogger() {
        return this.configureLogger;
    }

    public void addDataSource(ConnectionInfo info) {
        this.dataSources.add(info);
    }

    public List getDataSources() {
        return this.dataSources;
    }

    public void addDataSources(String dataSourcesFile) throws SimpleServerException, IOException {
        List dataSources = SimpleServerInfo.readDataSourceFile(dataSourcesFile);
        for (int i = 0; i < dataSources.size(); ++i) {
            ConnectionInfo info = (ConnectionInfo)dataSources.get(i);
            this.addDataSource(info);
        }
    }

    public void readDataSources(InputStream is, boolean readTransactions) throws Exception {
        byte[] bytes = IOUtil.readStream(is);
        ConnectionInfoList connectionInfoList = ConnectionInfoList.read(new ByteArrayInputStream(bytes));
        List list = connectionInfoList.getAllConnections();
        this.dataSources.addAll(list);
        Document document = XMLUtils.createDocument(new ByteArrayInputStream(bytes));
        if (readTransactions) {
            this.readTransactionManager(document);
        }
    }

    private void readTransactionManager(Document document) {
        Element element = document.getDocumentElement();
        Element tmElm = XMLUtils.getSingleChildElement(element, "transaction-manager");
        if (tmElm != null) {
            String serverLocation = tmElm.getAttribute("server-location");
            String className = tmElm.getAttribute("class");
            Properties props = new Properties();
            this.transactionInfo = new TransactionInfo(className, serverLocation, props);
        }
    }

    public static List readDataSourceFile(String dataSourcesFile) throws SimpleServerException, IOException {
        try {
            ConnectionInfoList connectionInfoList = ConnectionInfoList.read(dataSourcesFile);
            List dataSources = connectionInfoList.getAllConnections();
            return dataSources;
        }
        catch (Exception e) {
            throw SimpleResource.createSimpleExceptionFormatted("SIM121", e);
        }
    }

    public void readMailSources(InputStream is) throws SimpleServerException, IOException {
        try {
            Document document = XMLUtils.createDocument(is);
            List list = this.readMail(document.getDocumentElement());
            this.mailSources.addAll(list);
        }
        catch (Exception e) {
            throw SimpleResource.createSimpleExceptionFormatted("SIM121", e);
        }
    }

    public List readMail(Element nd) throws SchemaException {
        if (!nd.getTagName().equals(MAIL_SOURCES_TAG)) {
            throw new SchemaException("The root tag name should be 'mail-sources'");
        }
        ArrayList<MailInfo> infoList = new ArrayList<MailInfo>();
        NodeList dataSourceList = nd.getElementsByTagName(MAIL_SOURCE_TAG);
        for (int i = 0; i < dataSourceList.getLength(); ++i) {
            Element dsElm = (Element)dataSourceList.item(i);
            NamedNodeMap attribs = dsElm.getAttributes();
            MailInfo mailInfo = new MailInfo();
            for (int j = 0; j < attribs.getLength(); ++j) {
                Attr attr = (Attr)attribs.item(j);
                String attrName = attr.getName();
                String attrValue = attr.getValue();
                mailInfo.setProperty(attrName, attrValue);
            }
            NodeList propertyTags = XMLUtils.getChildElementsByTagName(dsElm, PROPERTY_TAG);
            for (int j = 0; j < propertyTags.getLength(); ++j) {
                Element propElm = (Element)propertyTags.item(j);
                String propName = propElm.getAttribute(NAME_ATTRIB);
                String propValue = propElm.getAttribute(VALUE_ATTRIB);
                mailInfo.setProperty(propName, propValue);
            }
            infoList.add(mailInfo);
        }
        return infoList;
    }

    public TransactionInfo getTransactionInfo() {
        return this.transactionInfo;
    }

    public List getMailSources() {
        return this.mailSources;
    }
}

