/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.simple;

import com.tplus.transform.util.StringUtils;
import com.volante.component.server.transaction.TransactionManagerFactory;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;

public class TransactionInfo {
    String className;
    String serverLocation;
    private Properties properties;

    public TransactionInfo(String className, String serverLocation, Properties properties) {
        this.className = className;
        this.serverLocation = serverLocation;
        this.properties = properties;
    }

    public String getClassName() {
        return this.className;
    }

    public String getServerLocation() {
        return this.serverLocation;
    }

    public TransactionManager getTransactionManager() throws NamingException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (!StringUtils.isEmpty(this.className)) {
            Class<?> cls = Class.forName(this.className);
            Object o = cls.newInstance();
            if (o instanceof TransactionManager) {
                TransactionManager tm = (TransactionManager)o;
                return tm;
            }
            if (o instanceof TransactionManagerFactory) {
                TransactionManagerFactory tmf = (TransactionManagerFactory)o;
                return tmf.getTransactionManager(this.properties);
            }
            throw new NamingException("The class " + this.className + " is not a transaction manager");
        }
        InitialContext initialContext = new InitialContext();
        TransactionManager tm = (TransactionManager)initialContext.lookup(this.serverLocation);
        return tm;
    }
}

