/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.simple.factory;

import com.tplus.transform.lang.CallListener;
import com.tplus.transform.lang.PoolingProxy;
import com.tplus.transform.lang.PoolingProxyImpl;
import com.tplus.transform.lang.StaticProxyImpl;
import com.tplus.transform.runtime.factory.CreateException;
import com.tplus.transform.runtime.factory.RuntimeElementFactory;
import com.tplus.transform.runtime.simple.SimpleResource;
import java.rmi.RemoteException;

public class RuntimeElementFactorySimple
implements RuntimeElementFactory {
    private String name;
    private Class implClass;
    private Class interfaceClass;
    private PoolingProxy poolingProxy;

    public RuntimeElementFactorySimple(String name, Class implClass, Class interfaceClass, boolean alwaysPool) throws RemoteException {
        this.name = name;
        this.implClass = implClass;
        this.interfaceClass = interfaceClass;
        Class staticProxy = this.getStaticProxyClass(interfaceClass);
        this.poolingProxy = staticProxy != null ? new StaticProxyImpl(implClass, interfaceClass, staticProxy) : new PoolingProxyImpl(implClass, interfaceClass);
    }

    private Class getStaticProxyClass(Class interfaceClass) {
        String name = interfaceClass.getName();
        int lastIndex = name.lastIndexOf(46);
        String packName = name.substring(0, lastIndex);
        String className = name.substring(lastIndex + 1);
        String proxyClasName = packName + ".proxy." + className + "Proxy";
        try {
            Class<?> proxyCls = Class.forName(proxyClasName);
            return proxyCls;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void addCallListener(CallListener callListener) {
        this.poolingProxy.addCallListener(callListener, this);
    }

    public void removeCallListener(CallListener callListener) {
        this.poolingProxy.removeCallListener(callListener);
    }

    public String getName() {
        return this.name;
    }

    public Class getInterfaceClass() {
        return this.interfaceClass;
    }

    public Class getImplClass() {
        return this.implClass;
    }

    public Object create(boolean pooled) throws CreateException {
        return this.create0(pooled);
    }

    private Object create0(boolean pooled) throws CreateException {
        try {
            Object implObj = pooled ? this.poolingProxy.getProxy() : this.poolingProxy.getObject();
            return implObj;
        }
        catch (InstantiationException e) {
            throw SimpleResource.createCreateExceptionFormatted("SIM120", e);
        }
        catch (IllegalAccessException e) {
            throw SimpleResource.createCreateExceptionFormatted("SIM120", e);
        }
    }

    public int getObjectCount() {
        return this.poolingProxy.getObjectCount();
    }

    public String toString() {
        return this.name;
    }
}

