/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.simple.profiler;

import com.tplus.transform.runtime.simple.profiler.CallReference;
import com.tplus.transform.util.TimeProvider;
import com.tplus.transform.util.TimeProviderImpl;
import java.util.ArrayList;
import java.util.List;

public class CallInfo {
    static TimeProvider timeProvider = new TimeProviderImpl();
    private CallReference callReference;
    Object instance;
    long startTime;
    long endTime;
    List child;
    private CallInfo parent;
    CallInfo next;

    public CallInfo(CallReference callReference, Object instance) {
        this.callReference = callReference;
        this.instance = instance;
        this.startTime = this.getTime();
    }

    private long getTime() {
        return timeProvider.getTime();
    }

    public void completed() {
        this.endTime = this.getTime();
    }

    public void addChild(CallInfo info) {
        if (this.child == null) {
            this.child = new ArrayList();
        }
        this.child.add(info);
        info.setParent(this);
    }

    public void setParent(CallInfo parent) {
        this.parent = parent;
    }

    public long getElapsedTime() {
        return this.endTime - this.startTime;
    }

    public long getElapsedTimeWithOutChild() {
        return this.getElapsedTime() - this.getChildElapsedTime();
    }

    public long getChildElapsedTime() {
        if (this.child != null) {
            long childTime = 0L;
            for (int i = 0; i < this.child.size(); ++i) {
                CallInfo callInfo = (CallInfo)this.child.get(i);
                childTime += callInfo.getElapsedTime();
            }
            return childTime;
        }
        return 0L;
    }
}

