/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.simple.profiler;

import com.tplus.transform.runtime.simple.profiler.CallInfo;
import com.tplus.transform.runtime.simple.profiler.CallReference;
import com.tplus.transform.runtime.simple.profiler.ElementReference;
import com.tplus.transform.util.MathUtils;
import com.tplus.transform.util.SequencedHashMap;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;

public class Profiler {
    long totalTime = 0L;
    Map elementReferences = new SequencedHashMap();

    public CallReference getCallReference(Object callbackReference, Object method) {
        ElementReference elementReference = (ElementReference)this.elementReferences.get(callbackReference);
        if (elementReference == null) {
            elementReference = new ElementReference(callbackReference);
            this.elementReferences.put(callbackReference, elementReference);
        }
        CallReference callReference = elementReference.getMethodReference(method);
        return callReference;
    }

    public void dump(PrintStream out) {
        out.println("Entity, Operation, Total calls, Time with child, Time, % time with child, % time");
        for (Map.Entry entry : this.elementReferences.entrySet()) {
            ElementReference reference = (ElementReference)entry.getValue();
            String refName = reference.getName();
            List list = reference.getCallReferences();
            for (int i = 0; i < list.size(); ++i) {
                CallReference callReference = (CallReference)list.get(i);
                String name = callReference.getMethodName();
                double totalPercent = MathUtils.round(callReference.getTotalElapsedTime() * 100.0 / (double)this.totalTime, 2);
                double totalWithOutChildPercent = MathUtils.round(callReference.getTotalElapsedTimeWithoutChild() * 100.0 / (double)this.totalTime, 2);
                out.println(refName + "," + name + "," + callReference.getTotalCalls() + "," + (long)(callReference.getTotalElapsedTime() / (double)(1000 * callReference.getTotalCalls())) + "," + (long)(callReference.getTotalElapsedTimeWithoutChild() / (double)(1000 * callReference.getTotalCalls())) + "," + totalPercent + "," + totalWithOutChildPercent);
            }
        }
    }

    public void consolidate() {
        this.totalTime = 0L;
        for (Map.Entry entry : this.elementReferences.entrySet()) {
            ElementReference reference = (ElementReference)entry.getValue();
            this.consolidate(reference);
            List list = reference.getCallReferences();
            for (int i = 0; i < list.size(); ++i) {
                CallReference callReference = (CallReference)list.get(i);
                this.totalTime = (long)((double)this.totalTime + callReference.getTotalElapsedTimeWithoutChild());
            }
        }
    }

    private void consolidate(ElementReference reference) {
        Object element = reference.getElement();
        List list = reference.getCallReferences();
        for (int i = 0; i < list.size(); ++i) {
            CallReference callReference = (CallReference)list.get(i);
            List callInfos = callReference.getCallInfos();
            double totalElapsedTime = 0.0;
            double totalElapsedTimeWithoutChild = 0.0;
            int totalCalls = callInfos.size();
            for (int j = 0; j < totalCalls; ++j) {
                CallInfo callInfo = (CallInfo)callInfos.get(j);
                totalElapsedTime += (double)callInfo.getElapsedTime();
                totalElapsedTimeWithoutChild += (double)callInfo.getElapsedTimeWithOutChild();
            }
            callReference.setTotalElapsedTime(totalElapsedTime);
            callReference.setTotalElapsedTimeWithoutChild(totalElapsedTimeWithoutChild);
            callReference.setTotalCalls(totalCalls);
        }
    }
}

