/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.simple.profiler;

import com.tplus.transform.lang.CallListener;
import com.tplus.transform.runtime.simple.profiler.CallInfo;
import com.tplus.transform.runtime.simple.profiler.CallReference;
import com.tplus.transform.runtime.simple.profiler.Profiler;

public class ProfilingCallListener
implements CallListener {
    ThreadLocal currentCallInfo = new ThreadLocal();
    private Profiler profiler;

    public ProfilingCallListener(Profiler profiler) {
        this.profiler = profiler;
    }

    public void onCallStart(Object callbackReference, Object obj, Object method) {
        CallReference callReference = this.profiler.getCallReference(callbackReference, method);
        CallInfo info = callReference.createCallInfo(obj);
        this.addChild(this.getCurrent(), info);
        this.setCurrent(info);
    }

    private void addChild(CallInfo current, CallInfo info) {
        info.next = current;
        if (current != null) {
            current.addChild(info);
        }
    }

    public void onCallEnd(Object callbackReference, Object obj, Object method) {
        CallInfo info = this.remove(obj);
        info.completed();
    }

    private CallInfo remove(Object obj) {
        CallInfo info = this.getCurrent();
        CallInfo prev = null;
        while (info != null) {
            if (info.instance == obj) {
                if (prev != null) {
                    prev.next = info.next;
                } else {
                    this.setCurrent(info.next);
                }
                return info;
            }
            prev = info;
            info = info.next;
        }
        return null;
    }

    public CallInfo getCurrent() {
        CallInfo callInfo = (CallInfo)this.currentCallInfo.get();
        return callInfo;
    }

    public void setCurrent(CallInfo current) {
        this.currentCallInfo.set(current);
    }
}

