/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.simple.standard;

import com.tplus.transform.runtime.BatchContext;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.simple.SimpleResource;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;

public class BatchContextSimple
implements BatchContext {
    private Map context = new HashMap();
    private Map devices = new HashMap();

    public Map getProperties() throws RemoteException, TransformException {
        return this.context;
    }

    public Object getBatchProperty(String name) throws RemoteException {
        return this.context.get(name);
    }

    public boolean hasBatchProperty(String name) throws RemoteException {
        return this.context.containsKey(name);
    }

    public void setBatchProperty(String name, Object value) throws RemoteException {
        if (value != null) {
            this.context.put(name, value);
        } else {
            this.context.remove(name);
        }
    }

    public void addOutputDevice(String devicePropertyName, OutputDevice device) throws RemoteException, TransformException {
        this.devices.put(devicePropertyName, device);
    }

    public void writeToDevice(String devicePropertyName, Object data) throws RemoteException, TransformException {
        OutputDevice device = (OutputDevice)this.devices.get(devicePropertyName);
        if (device == null) {
            throw SimpleResource.createFormatted(TransformException.class, "SIM100", devicePropertyName);
        }
        device.write(data);
    }

    public void closeDevice(String devicePropertyName) throws RemoteException, TransformException {
        OutputDevice device = (OutputDevice)this.devices.get(devicePropertyName);
        if (device == null) {
            throw SimpleResource.createFormatted(TransformException.class, "SIM100", devicePropertyName);
        }
        device.close();
        this.devices.remove(devicePropertyName);
    }

    public void clear() throws RemoteException, TransformException {
        this.closeAllDevices();
        this.context.clear();
    }

    private void closeAllDevices() {
        for (Map.Entry entry : this.devices.entrySet()) {
            OutputDevice device = (OutputDevice)entry.getValue();
            try {
                device.close();
            }
            catch (Exception e) {}
        }
        this.devices.clear();
    }

    public void endBatch() throws RemoteException, TransformException {
        this.clear();
    }
}

