/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.simple.standard;

import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.LookupContextFactory;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.OutputDeviceFactory;
import com.tplus.transform.runtime.OutputProtocol;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.NamingException;

public class RMIOutputProtocolSimple
implements OutputProtocol {
    private Hashtable factoryObjects = new Hashtable();
    boolean cacheFactoryObjects = false;
    private LookupContext cxt;

    public RMIOutputProtocolSimple() throws RemoteException {
        try {
            this.cxt = LookupContextFactory.getLookupContext(RMIOutputProtocolSimple.class);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public OutputDevice createDevice(DeviceInfo deviceInfo, TransformContext cxt) throws RemoteException, TransformException {
        OutputDevice device = this.getRMIDevice(deviceInfo, cxt);
        return device;
    }

    public void send(Object toSend, DeviceInfo deviceInfo, TransformContext cxt) throws RemoteException, TransformException {
        OutputDeviceFactory deviceFactory = this.getRMIDeviceFactory(deviceInfo, cxt);
        deviceFactory.send(toSend, deviceInfo, cxt);
    }

    private OutputDevice getRMIDevice(DeviceInfo deviceInfo, TransformContext tcxt) throws RemoteException, TransformException {
        String deviceFactoryName = deviceInfo.getDeviceFactoryName();
        OutputDeviceFactory factory = this.getDeviceFactory(deviceFactoryName, tcxt);
        OutputDevice device = factory.createDevice(deviceInfo, tcxt);
        return device;
    }

    private OutputDeviceFactory getRMIDeviceFactory(DeviceInfo deviceInfo, TransformContext cxt) throws RemoteException, TransformException {
        String deviceFactoryName = deviceInfo.getDeviceFactoryName();
        OutputDeviceFactory factory = this.getDeviceFactory(deviceFactoryName, cxt);
        return factory;
    }

    private OutputDeviceFactory getDeviceFactory(String name, TransformContext tcxt) throws TransformException {
        OutputDeviceFactory outputDeviceFactory = this.getFactoryFromContext(name, tcxt);
        if (outputDeviceFactory != null) {
            return outputDeviceFactory;
        }
        OutputDeviceFactory outputDeviceFactory2 = outputDeviceFactory = this.cacheFactoryObjects ? (OutputDeviceFactory)this.factoryObjects.get(name) : null;
        if (outputDeviceFactory == null) {
            try {
                outputDeviceFactory = (OutputDeviceFactory)this.cxt.lookup(name);
                if (this.cacheFactoryObjects) {
                    this.factoryObjects.put(name, outputDeviceFactory);
                }
            }
            catch (NamingException e) {
                throw new TransformException("Unable to lookup RMI output device '" + name + "'");
            }
            catch (ClassCastException e) {
                throw new TransformException("Unexpected object in JNDI - expected RMI output device for " + name);
            }
        }
        return outputDeviceFactory;
    }

    private OutputDeviceFactory getFactoryFromContext(String name, TransformContext tcxt) {
        OutputDeviceFactory outputDeviceFactory = null;
        Object property = tcxt.getProperty(name);
        if (property == null) {
            property = tcxt.getProperty("device.*");
        }
        if (property instanceof OutputDeviceFactory) {
            outputDeviceFactory = (OutputDeviceFactory)property;
            return outputDeviceFactory;
        }
        return outputDeviceFactory;
    }
}

