/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.vm;

import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.vm.Location;
import com.tplus.transform.runtime.vm.LocationImpl;
import java.util.ArrayList;
import java.util.List;

public class LocationManager {
    public static final LocationManager EMPTY = new LocationManager();
    List locations = new ArrayList();

    public LocationManager addLocation(String name) {
        this.locations.add(new LocationImpl(name));
        return this;
    }

    public LocationManager addLocation(String name, int index) {
        this.locations.add(new LocationImpl(name, index));
        return this;
    }

    public LocationManager addLocation(String name, String index) {
        this.locations.add(new LocationImpl(name, index));
        return this;
    }

    public Location getLocation(int index) {
        if (index < 0) {
            return null;
        }
        return (Location)this.locations.get(index);
    }

    public void onLocation2(int index, String[] names, Object[] values, AbstractServiceElement serviceElement) {
        Location location = this.getLocation(index);
        if (this.checkLocation(location) && serviceElement != null) {
            serviceElement.onSubstatement(location, names, values);
        }
    }

    public void onLocation(int index, AbstractServiceElement serviceElement) {
        Location location = this.getLocation(index);
        if (this.checkLocation(location) && serviceElement != null) {
            serviceElement.onStatement(location);
        }
    }

    private boolean checkLocation(Location location) {
        if (location == null || !location.isEnabled()) {
            // empty if block
        }
        return true;
    }

    public void onLocation(int index, String[] names, Object[] values, AbstractServiceElement serviceElement) {
        Location location = this.getLocation(index);
        if (this.checkLocation(location) && serviceElement != null) {
            serviceElement.onStatement(location, names, values);
        }
    }

    public void onLocationDelta(int index, AbstractServiceElement serviceElement) {
        Location location = this.getLocation(index);
        if (this.checkLocation(location) && serviceElement != null) {
            serviceElement.onSubstatementDelta(index);
        }
    }

    public void onLocationDelta(int index, String[] names, Object[] values, AbstractServiceElement serviceElement) {
        Location location = this.getLocation(index);
        if (this.checkLocation(location) && serviceElement != null) {
            serviceElement.onSubstatementDelta(location, names, values);
        }
    }

    public List getLocations() {
        return this.locations;
    }
}

