/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.vm;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.vm.Location;
import com.tplus.transform.runtime.vm.OperationInfo;
import com.tplus.transform.runtime.vm.ThreadInfo;
import com.tplus.transform.runtime.vm.VMEventType;
import com.tplus.transform.runtime.vm.VariableInfo;
import com.tplus.transform.util.ArrayUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class StackFrame
implements Serializable {
    static int FRAME_ID_INDEX;
    private boolean stopped;
    final OperationInfo operationInfo;
    Location location;
    private final int frameId;
    private transient String[] localNames;
    private transient Object[] localValues;
    private transient StackFrame previousFrame;
    final transient List variables;
    final ThreadInfo threadInfo;

    public StackFrame(ThreadInfo threadInfo, OperationInfo operationInfo, List variables) {
        this.threadInfo = threadInfo;
        this.previousFrame = threadInfo.getStackFrame();
        this.operationInfo = operationInfo;
        if (operationInfo == null) {
            throw new NullPointerException();
        }
        this.variables = variables;
        if (this.variables == null) {
            throw new NullPointerException();
        }
        this.frameId = ++FRAME_ID_INDEX;
        threadInfo.setStackFrame(this);
    }

    public ThreadInfo getThreadInfo() {
        return this.threadInfo;
    }

    public StackFrame getPreviousFrame() {
        return this.previousFrame;
    }

    public OperationInfo getOperationInfo() {
        return this.operationInfo;
    }

    public Location getLocation() {
        return this.location;
    }

    public void onVariableUpdate(VariableInfo newVariableInfo) {
        for (int i = 0; i < this.variables.size(); ++i) {
            VariableInfo variableInfo = (VariableInfo)this.variables.get(i);
            if (!variableInfo.getName().equals(newVariableInfo.getName())) continue;
            this.variables.set(i, newVariableInfo);
            break;
        }
    }

    public List getVariables() {
        ArrayList<VariableInfo> toRet = new ArrayList<VariableInfo>(this.variables.size() + 2);
        for (int i = 0; i < this.variables.size(); ++i) {
            VariableInfo variableInfo = (VariableInfo)this.variables.get(i);
            if (variableInfo.getName().equals("Compound")) {
                DataObject dataObject = (DataObject)variableInfo.getValue();
                int fieldCount = dataObject.getFieldCount();
                for (int j = 0; j < fieldCount; ++j) {
                    toRet.add(new VariableInfo(dataObject.getFieldName(j), dataObject.getField(j)));
                }
                continue;
            }
            toRet.add(variableInfo);
        }
        return toRet;
    }

    public Location getCurrentLocation() {
        return this.location;
    }

    public String getCurrentLocationName() {
        return this.location == null ? null : this.location.getName();
    }

    public void onStatement(Location location) {
        this.location = location;
        this.localNames = null;
        this.localValues = null;
        this.threadInfo.getVolanteVM().onStatement(this, location);
    }

    public void onStatement(Location location, String[] names, Object[] values) {
        this.location = location;
        this.localNames = names;
        this.localValues = values;
        this.threadInfo.getVolanteVM().onStatement(this, location);
    }

    public void onSubstatement(Location location, String[] names, Object[] values) {
        this.location = location;
        this.localNames = names;
        this.localValues = values;
        this.threadInfo.getVolanteVM().onSubstatement(this, location);
    }

    public void onSubstatementDelta(Location location) {
        this.location = location;
        this.threadInfo.getVolanteVM().onSubstatement(this, location);
    }

    public void onSubstatementDelta(Location location, String[] names, Object[] values) {
        this.updateVariables(names, values);
        if (location != null) {
            this.location = location;
            this.threadInfo.getVolanteVM().onSubstatement(this, location);
        }
    }

    private void updateVariables(String[] names, Object[] values) {
        block0: for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            for (int j = 0; j < this.localNames.length; ++j) {
                String localName = this.localNames[j];
                if (!name.equals(localName)) continue;
                this.localValues[j] = values[i];
                continue block0;
            }
            this.localNames = (String[])ArrayUtils.addArrayAndObject(this.localNames, names[i]);
            this.localValues = (Object[])ArrayUtils.addArrayAndObject(this.localValues, values[i]);
        }
    }

    public void onExit() {
        this.threadInfo.setStackFrame(this.previousFrame);
    }

    public void finished() {
        this.location = null;
        this.stopped = true;
    }

    public String toString() {
        if (this.location != null) {
            return "[" + this.operationInfo.getEntityInfo().getName() + "]" + this.operationInfo.getName() + ":" + this.location;
        }
        if (this.stopped) {
            return "[" + this.operationInfo.getEntityInfo().getName() + "]" + this.operationInfo.getName() + ":" + VMEventType.OPERATION_EXITED;
        }
        return "[" + this.operationInfo.getEntityInfo().getName() + "]" + this.operationInfo.getName() + ":" + VMEventType.OPERATION_ENTERED;
    }

    public boolean isEnter() {
        return !this.stopped && this.location == null;
    }

    public boolean isExit() {
        return this.stopped && this.location == null;
    }

    public String[] getLocalNames() {
        return this.localNames;
    }

    public Object[] getLocalValues() {
        return this.localValues;
    }

    public int getFrameId() {
        return this.frameId;
    }
}

