/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.vm;

import com.tplus.transform.runtime.vm.EntityInfo;
import com.tplus.transform.runtime.vm.Location;
import com.tplus.transform.runtime.vm.OperationInfo;
import com.tplus.transform.runtime.vm.StackFrame;
import com.tplus.transform.runtime.vm.ThreadInfo;
import com.tplus.transform.runtime.vm.VMEvent;
import com.tplus.transform.runtime.vm.VMEventListener;
import com.tplus.transform.runtime.vm.VMEventType;
import com.tplus.transform.runtime.vm.VariableInfo;
import com.tplus.transform.runtime.vm.VolanteVM;
import com.tplus.transform.runtime.vm.WeakThreadLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class VolanteVMImpl
extends VolanteVM {
    final List allThreadInfos = Collections.synchronizedList(new ArrayList());
    final ThreadLocal threadLocalInfo = new WeakThreadLocal();
    VMEventType eventThreshold = VMEventType.VM_EXIT;
    private final List listeners = new ArrayList();
    private final Map entityMap = new Hashtable();

    public void onStart() {
        this.onEvent(VMEventType.VM_START, this.getCurrentFrame());
    }

    public void onExit() {
        this.onEvent(VMEventType.VM_EXIT, this.getCurrentFrame());
    }

    private void onEvent(VMEventType eventType, StackFrame stackFrame) {
        if (this.eventThreshold.getOrdinal() >= VMEventType.STATEMENT.getOrdinal()) {
            this.onEvent(new VMEvent(this, eventType, stackFrame));
        }
    }

    public StackFrame onEnter(OperationInfo operationInfo, Object reference, List variables) {
        StackFrame currentFrame = new StackFrame(this.getCurrentThreadInfo(), operationInfo, variables);
        this.onEvent(VMEventType.OPERATION_ENTERED, currentFrame);
        return currentFrame;
    }

    public void onExit(StackFrame stackFrame) {
        stackFrame.finished();
        this.onEvent(VMEventType.OPERATION_EXITED, stackFrame);
        stackFrame.onExit();
    }

    public StackFrame getCurrentFrame(ThreadInfo threadInfo) {
        if ((threadInfo = this.findThreadInfo(threadInfo)) != null) {
            return threadInfo.getStackFrame();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadInfo findThreadInfo(ThreadInfo threadInfo) {
        List list = this.allThreadInfos;
        synchronized (list) {
            for (ThreadInfo info : this.allThreadInfos) {
                if (info == null || info.getThreadId() != threadInfo.getThreadId()) continue;
                return info;
            }
        }
        return null;
    }

    public ThreadInfo getThreadInfo() {
        return this.getCurrentThreadInfo();
    }

    private StackFrame getCurrentFrame() {
        ThreadInfo threadInfo = this.getCurrentThreadInfo();
        return threadInfo.getStackFrame();
    }

    private ThreadInfo getCurrentThreadInfo() {
        ThreadInfo threadInfo = (ThreadInfo)this.threadLocalInfo.get();
        if (threadInfo == null) {
            threadInfo = new ThreadInfo(this);
            this.threadLocalInfo.set(threadInfo);
            this.allThreadInfos.add(threadInfo);
        }
        return threadInfo;
    }

    private void checkOperationInStack() {
    }

    public void onStatement(StackFrame stackFrame, Location location) {
        this.onEvent(VMEventType.STATEMENT, stackFrame);
    }

    public void onSubstatement(StackFrame stackFrame, Location location) {
        this.onEvent(VMEventType.SUB_STATEMENT, stackFrame);
    }

    public void onVariableUpdate(StackFrame stackFrame, String varName, Object value) {
        if (stackFrame != null) {
            stackFrame.onVariableUpdate((VariableInfo)this.createVariableInfo(varName, value));
        }
    }

    public synchronized void registerEntity(EntityInfo entityInfo) {
        this.entityMap.put(entityInfo.getName(), entityInfo);
    }

    public Object createVariableInfo(String variableName1, Object variable1) {
        return new VariableInfo(variableName1, variable1);
    }

    public synchronized void addListener(VMEventListener vmEventListener, VMEventType threshold) {
        this.listeners.add(vmEventListener);
        this.eventThreshold = threshold;
        this.onEvent(VMEventType.VM_START, this.getCurrentFrame());
    }

    public synchronized void removeListener(VMEventListener eventListener) {
        this.listeners.remove(eventListener);
        if (this.listeners.size() == 0) {
            this.eventThreshold = VMEventType.VM_EXIT;
        }
    }

    public boolean hasListeners() {
        return this.listeners.size() > 0;
    }

    private void onEvent(VMEvent event) {
        if (this.listeners.size() > 0) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                VMEventListener vmEventListener = (VMEventListener)this.listeners.get(i);
                vmEventListener.onEvent(event);
            }
        }
    }

    public ThreadInfo resolveThreadInfo(ThreadInfo threadInfo) {
        return this.findThreadInfo(threadInfo);
    }

    public List getAllThreads() {
        return new ArrayList(this.allThreadInfos);
    }

    public List getExecutionStack(ThreadInfo threadInfo) {
        ArrayList<StackFrame> executionStack = new ArrayList<StackFrame>();
        for (StackFrame frame = this.getCurrentFrame(threadInfo); frame != null; frame = frame.getPreviousFrame()) {
            executionStack.add(frame);
        }
        Collections.reverse(executionStack);
        return executionStack;
    }

    public static VolanteVM getInstance() {
        return instance;
    }

    static {
        instance = new VolanteVMImpl();
    }
}

