/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.vm.debugger.impl;

import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.vm.EntityInfo;
import com.tplus.transform.runtime.vm.Location;
import com.tplus.transform.runtime.vm.OperationInfo;
import com.tplus.transform.runtime.vm.StackFrame;
import com.tplus.transform.runtime.vm.StopError;
import com.tplus.transform.runtime.vm.ThreadInfo;
import com.tplus.transform.runtime.vm.VMEvent;
import com.tplus.transform.runtime.vm.VMEventListener;
import com.tplus.transform.runtime.vm.VMEventType;
import com.tplus.transform.runtime.vm.VariableInfo;
import com.tplus.transform.runtime.vm.VolanteVM;
import com.tplus.transform.runtime.vm.VolanteVMImpl;
import com.tplus.transform.runtime.vm.debugger.Breakpoint;
import com.tplus.transform.runtime.vm.debugger.DebugListener;
import com.tplus.transform.runtime.vm.debugger.Debugger;
import com.tplus.transform.runtime.vm.debugger.impl.StepOperation;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.log.Log;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractDebugger
implements Debugger,
VMEventListener {
    protected static Log log = LogFactory.getRuntimeLog("debugger");
    StepOperation stepOperation;
    private OperationInfo stepOperationInfo;
    private Location stepLocation;
    Set breakPoints = new HashSet();
    private DebugListener debugListener;
    private boolean eventsEnabled;
    private StackFrame pausedFrame;
    private boolean stopOnNextEvent;
    private boolean stop;
    private VMEvent pausedEvent;

    protected AbstractDebugger() throws RemoteException {
    }

    public void attach() {
        this.getVM().addListener(this, VMEventType.SUB_STATEMENT);
    }

    public void detach() {
        this.getVM().removeListener(this);
    }

    public void stop() {
        this.stop = true;
    }

    public boolean isEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setEventsEnabled(boolean eventsEnabled) {
        this.eventsEnabled = eventsEnabled;
    }

    public Collection getBreakPoints() {
        return this.breakPoints;
    }

    public boolean addBreakPoint(Breakpoint breakpoint) {
        if (!this.breakPoints.contains(breakpoint)) {
            this.breakPoints.add(breakpoint);
            return true;
        }
        return false;
    }

    public boolean removeBreakPoint(Breakpoint breakpoint) {
        return this.breakPoints.remove(breakpoint);
    }

    public boolean isSingleStep() {
        return this.stepOperation == StepOperation.STEP_INTO;
    }

    public void setSingleStep(boolean singleStep) {
        this.stepOperation = StepOperation.STEP_INTO;
    }

    public void stepOut() {
        this.stepOperation = StepOperation.STEP_OUT;
        if (this.pausedFrame != null) {
            this.stepOperationInfo = this.pausedFrame.getOperationInfo();
            this.stepLocation = this.pausedFrame.getLocation();
            if (this.pausedEvent.getEventType() == VMEventType.OPERATION_EXITED) {
                this.stopOnNextEvent = true;
            }
        }
    }

    public void stepOver() {
        this.stepOperation = StepOperation.STEP_OVER;
        this.recordCurrentOperation();
    }

    private void recordCurrentOperation() {
        if (this.pausedFrame != null) {
            this.stepOperationInfo = this.pausedFrame.getOperationInfo();
            this.stepLocation = this.pausedFrame.getLocation();
        }
    }

    public void go() {
        this.stepOperation = null;
        this.stepOperationInfo = null;
    }

    public StackFrame getPausedFrame() {
        return this.pausedFrame;
    }

    public List getExecutionStack(ThreadInfo threadInfo) {
        return this.getVM().getExecutionStack(threadInfo);
    }

    public List getVariables(StackFrame stackFrame) {
        StackFrame frame = this.findFrame(stackFrame);
        List list = frame.getVariables();
        return list;
    }

    public List getLocalVariables(StackFrame stackFrame) {
        StackFrame frame = this.findFrame(stackFrame);
        String[] names = frame.getLocalNames();
        Object[] localValues = frame.getLocalValues();
        ArrayList<Object> list = new ArrayList<Object>();
        if (names != null) {
            VolanteVM volanteVM = this.getVM();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                Object value = localValues[i];
                list.add(volanteVM.createVariableInfo(name, value));
            }
        }
        return list;
    }

    public List getVariableNames(StackFrame stackFrame) {
        StackFrame frame = this.findFrame(stackFrame);
        List list = frame.getVariables();
        ArrayList<String> toRet = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            VariableInfo variableInfo = (VariableInfo)list.get(i);
            toRet.add(variableInfo.getName());
        }
        return toRet;
    }

    public Object getVariableValue(StackFrame stackFrame, String name) {
        StackFrame frame = this.findFrame(stackFrame);
        if (frame != null) {
            return this.getVariableValue0(frame, name);
        }
        return null;
    }

    private Object getVariableValue0(StackFrame frame, String name) {
        String[] localNames = frame.getLocalNames();
        Object[] localValues = frame.getLocalValues();
        if (localNames != null) {
            for (int i = 0; i < localNames.length; ++i) {
                String localName = localNames[i];
                if (!localName.equals(name)) continue;
                return localValues[i];
            }
        }
        List list = frame.getVariables();
        for (int i = 0; i < list.size(); ++i) {
            VariableInfo variableInfo = (VariableInfo)list.get(i);
            if (!variableInfo.getName().equals(name)) continue;
            return variableInfo.getValue();
        }
        return null;
    }

    public List getVariableValues(StackFrame stackFrame, List names) {
        StackFrame frame = this.findFrame(stackFrame);
        ArrayList<Object> toRet = new ArrayList<Object>();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            toRet.add(this.getVariableValue0(frame, name));
        }
        return toRet;
    }

    public void addDebugListener(DebugListener debugListener) {
        this.debugListener = debugListener;
    }

    private StackFrame findFrame(StackFrame stackFrame) {
        ThreadInfo threadInfo = this.getVM().resolveThreadInfo(stackFrame.getThreadInfo());
        if (threadInfo != null) {
            return threadInfo.getStackFrame();
        }
        return null;
    }

    protected void onBreakpoint(Breakpoint breakpoint) throws RemoteException {
        this.stopOnNextEvent = false;
        if (this.debugListener != null) {
            this.debugListener.onBreakpoint(breakpoint);
        }
    }

    protected void onStep(VMEvent event) throws RemoteException {
        this.stopOnNextEvent = false;
        this.debugListener.onStep();
    }

    protected VolanteVM getVM() {
        return VolanteVMImpl.getInstance();
    }

    public void onEvent(VMEvent event) {
        try {
            Breakpoint breakpoint;
            if (this.stop) {
                throw new StopError();
            }
            this.pausedEvent = event;
            this.pausedFrame = event.getStackFrame();
            this.logEvent(event);
            if (this.eventsEnabled && this.debugListener != null) {
                this.debugListener.onEvent(event);
            }
            if (this.stopOnNextEvent) {
                this.onStep(event);
                return;
            }
            if (this.stepOperation == StepOperation.STEP_INTO) {
                this.onStep(event);
                return;
            }
            if (this.stepOperation == StepOperation.STEP_OUT) {
                if (event.getEventType() == VMEventType.OPERATION_EXITED && event.getStackFrame().getOperationInfo().equals(this.stepOperationInfo)) {
                    this.stopOnNextEvent = true;
                    return;
                }
            } else if (this.stepOperation == StepOperation.STEP_OVER) {
                StackFrame frame = event.getStackFrame();
                if (frame.getOperationInfo().equals(this.stepOperationInfo)) {
                    Location currentLocation = frame.getLocation();
                    if (!this.isChildLocation(this.stepLocation, currentLocation)) {
                        this.onStep(event);
                    }
                    return;
                }
                if (!this.isOperationOnStack(frame, this.stepOperationInfo)) {
                    this.onStep(event);
                    return;
                }
            }
            if ((breakpoint = this.getBreakpoint(event)) != null) {
                this.onBreakpoint(breakpoint);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void logEvent(VMEvent event) {
    }

    private boolean isChildLocation(Location parent, Location child) {
        return parent != null && child != null && parent.getName().equals(child.getName()) && parent.getSubLocation() == null && child.getSubLocation() != null;
    }

    private boolean isOperationOnStack(StackFrame frame, OperationInfo stepOutOperation) {
        for (frame = frame.getPreviousFrame(); frame != null; frame = frame.getPreviousFrame()) {
            if (!frame.getOperationInfo().equals(stepOutOperation)) continue;
            return true;
        }
        return false;
    }

    private Breakpoint getBreakpoint(VMEvent event) {
        if (this.breakPoints.size() > 0) {
            VMEventType eventType = event.getEventType();
            StackFrame frame = event.getStackFrame();
            if (frame != null) {
                OperationInfo operationInfo = frame.getOperationInfo();
                EntityInfo entityInfo = operationInfo.getEntityInfo();
                String name = entityInfo.getName();
                for (Breakpoint breakpoint : this.breakPoints) {
                    String subLocationName;
                    if (breakpoint.getEventType() != eventType || !breakpoint.getEntityName().equals(name) || breakpoint.getOperation() != null && !breakpoint.getOperation().equals(operationInfo.getName())) continue;
                    Location currentLocation = frame.getCurrentLocation();
                    String locationName = currentLocation != null ? currentLocation.getName() : null;
                    String string = subLocationName = currentLocation != null ? currentLocation.getSubLocation() : null;
                    if (!StringUtils.valueEquals(breakpoint.getLocation(), locationName) || !StringUtils.valueEquals(breakpoint.getSubLocation(), subLocationName)) continue;
                    return breakpoint;
                }
            }
        }
        return null;
    }
}

