/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.vm.debugger.impl;

import com.tplus.transform.runtime.vm.StackFrame;
import com.tplus.transform.runtime.vm.VMEvent;
import com.tplus.transform.runtime.vm.VMEventType;
import com.tplus.transform.runtime.vm.debugger.Breakpoint;
import com.tplus.transform.runtime.vm.debugger.DebugListener;
import com.tplus.transform.runtime.vm.debugger.Debugger;
import com.tplus.transform.runtime.vm.debugger.impl.RemoteDebugger;
import com.tplus.transform.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ConsoleDebugger
implements DebugListener {
    BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
    private static Set commonOperations = new HashSet<String>(Arrays.asList("map", "parse", "validate", "serialize", "run"));
    Debugger debugger = new RemoteDebugger();
    boolean logEvent;

    public ConsoleDebugger() throws RemoteException {
        this.debugger.setEventsEnabled(true);
        this.debugger.addDebugListener(this);
    }

    public boolean isLogEvent() {
        return this.logEvent;
    }

    public void setLogEvent(boolean logEvent) {
        this.logEvent = logEvent;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public void onStep() {
        this.pause();
    }

    public void onEvent(VMEvent event) {
        this.logEvent(event);
    }

    public void onBreakpoint(Breakpoint breakpoint) {
        this.pause();
    }

    protected void logEvent(VMEvent event) {
        StackFrame frame = event.getStackFrame();
        if (frame != null) {
            System.out.println(frame);
        } else {
            System.out.println("[ ]" + event.getEventType());
        }
    }

    void dumpVariables() throws RemoteException {
        StackFrame frame = this.debugger.getPausedFrame();
        if (frame != null) {
            System.out.println(frame.getVariables());
        }
    }

    void dumpStack() throws RemoteException {
        ArrayList list = new ArrayList(this.debugger.getExecutionStack(this.debugger.getPausedFrame().getThreadInfo()));
        Collections.reverse(list);
        for (int i = 0; i < list.size(); ++i) {
            StackFrame stackFrame = (StackFrame)list.get(i);
            System.out.print(StringUtils.getString(' ', i * 2));
            System.out.println(stackFrame);
        }
    }

    void pause() {
        block13: {
            try {
                System.out.print(">");
                String command = this.reader.readLine();
                if (command == null || command.equals("")) {
                    return;
                }
                if (command.equals("s")) {
                    this.debugger.setSingleStep(true);
                    return;
                }
                if (command.equals("o")) {
                    this.debugger.stepOut();
                    return;
                }
                if (command.equals("g")) {
                    this.debugger.go();
                    return;
                }
                if (command.equals("d")) {
                    this.dumpVariables();
                    this.pause();
                    return;
                }
                if (command.startsWith("b ")) {
                    String breakpointStr = command.substring(2);
                    Breakpoint breakpoint = this.createBreakpoint(breakpointStr);
                    this.debugger.addBreakPoint(breakpoint);
                    this.pause();
                    break block13;
                }
                if (command.startsWith("rb ")) {
                    String breakpointStr = command.substring(3);
                    Breakpoint breakpoint = this.createBreakpoint(breakpointStr);
                    this.debugger.removeBreakPoint(breakpoint);
                    this.pause();
                    break block13;
                }
                if (command.startsWith("lb")) {
                    Collection breakPoints = this.debugger.getBreakPoints();
                    for (Breakpoint breakpoint : breakPoints) {
                        System.out.println(breakpoint);
                    }
                    this.pause();
                    break block13;
                }
                if (command.equals("t")) {
                    this.dumpStack();
                    this.pause();
                    return;
                }
                if (command.equals("q")) {
                    System.exit(-1);
                    return;
                }
                this.pause();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Breakpoint createBreakpoint(String breakpoint) {
        Breakpoint bk;
        String[] names = StringUtils.split(breakpoint, " ");
        String entityName = names[0];
        String operation = null;
        String statementRef = null;
        if (names.length > 1) {
            operation = names[1];
        }
        if (!commonOperations.contains(operation)) {
            statementRef = operation;
            operation = null;
        }
        if (names.length > 2) {
            statementRef = names[2];
        }
        if (statementRef != null) {
            bk = new Breakpoint(VMEventType.STATEMENT, entityName, operation);
            bk.setLocation(statementRef);
        } else {
            bk = new Breakpoint(VMEventType.OPERATION_ENTERED, entityName, operation);
        }
        return bk;
    }
}

