/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.volante;

import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.volante.Task;
import com.tplus.transform.runtime.volante.TransactionalExecutor;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.rmi.RemoteException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class DeclarativeTransactionalExecutor
implements TransactionalExecutor {
    protected static Log log = LogFactory.getLog(DeclarativeTransactionalExecutor.class, "volante.runtime.tm");
    private final int transactionType;
    final TransactionManager tm;
    boolean newTransactionStarted;
    private Transaction oldTransaction;
    static boolean debugEnabled = log.isDebugEnabled();

    public DeclarativeTransactionalExecutor(TransactionManager tm, int transactionType) {
        this.tm = tm;
        this.transactionType = transactionType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void begin() throws SystemException, NotSupportedException {
        if (this.transactionType == 0) {
            int status = this.tm.getStatus();
            if (status == 6) return;
            this.oldTransaction = this.tm.suspend();
            if (!debugEnabled) return;
            log.debug("Suspending transaction " + this.oldTransaction);
            return;
        } else if (this.transactionType == 1) {
            int status = this.tm.getStatus();
            if (status != 6) return;
            this.tm.begin();
            if (debugEnabled) {
                log.debug("Starting new transaction " + this.tm.getTransaction());
            }
            this.newTransactionStarted = true;
            return;
        } else {
            if (this.transactionType != 2) return;
            int status = this.tm.getStatus();
            if (status != 6) {
                this.oldTransaction = this.tm.suspend();
                if (debugEnabled) {
                    log.debug("Suspending transaction " + this.oldTransaction);
                }
            }
            this.tm.begin();
            if (debugEnabled) {
                log.debug("Starting new transaction " + this.tm.getTransaction());
            }
            this.newTransactionStarted = true;
        }
    }

    public void finish() throws SystemException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException {
        if (this.newTransactionStarted) {
            if (this.tm.getStatus() == 1) {
                if (debugEnabled) {
                    log.debug("Rolling back transaction " + this.tm.getTransaction());
                }
                this.tm.rollback();
            } else {
                if (debugEnabled) {
                    log.debug("Committing transaction " + this.tm.getTransaction());
                }
                this.tm.commit();
            }
        }
        if (this.oldTransaction != null) {
            if (debugEnabled) {
                log.debug("Resuming transaction " + this.oldTransaction);
            }
            this.tm.resume(this.oldTransaction);
        }
    }

    public void setRollbackOnly() throws SystemException {
        if (this.transactionType != 0 && this.tm.getStatus() != 6) {
            Transaction trans = this.tm.getTransaction();
            if (debugEnabled) {
                log.debug("Setting status of transaction as RollbackOnly " + trans);
            }
            trans.setRollbackOnly();
        }
    }

    public Object start(Task task) throws RemoteException, TransformException {
        Throwable ex;
        this.newTransactionStarted = false;
        this.oldTransaction = null;
        try {
            return this.start0(task);
        }
        catch (SystemException e) {
            ex = e;
        }
        catch (NotSupportedException e) {
            ex = e;
        }
        catch (HeuristicMixedException e) {
            ex = e;
        }
        catch (HeuristicRollbackException e) {
            ex = e;
        }
        catch (RollbackException e) {
            ex = e;
        }
        throw new RemoteException("Transaction exception", ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object start0(Task task) throws RemoteException, TransformException, SystemException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException {
        this.begin();
        try {
            Object object = task.run();
            return object;
        }
        catch (Throwable e) {
            this.handleException(e);
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            this.finish();
        }
    }

    void handleException(Throwable e) throws TransformException, RemoteException, SystemException {
        if (e instanceof TransformException) {
            this.setRollbackOnly();
            throw (TransformException)e;
        }
        if (e instanceof RemoteException) {
            throw (RemoteException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RemoteException("Unexpected runtime exception", e);
    }
}

