/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.volante;

import com.tplus.transform.runtime.Callable;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.LookupContextFactory;
import com.tplus.transform.runtime.MessageFlow;
import com.tplus.transform.runtime.Result;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.volante.DeclarativeTransactionalExecutor;
import com.tplus.transform.runtime.volante.Task;
import com.tplus.transform.runtime.volante.TransactionalExecutor;
import java.rmi.RemoteException;
import java.util.List;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

public class MessageFlowVolante
implements MessageFlow {
    protected MessageFlow messageFlow;
    private int transactionType;
    private transient TransactionManager tm;

    public MessageFlowVolante(MessageFlow messageFlow, int transactionType) {
        this.messageFlow = messageFlow;
        this.transactionType = transactionType;
    }

    private TransactionManager getTransactionManager() throws RemoteException {
        if (this.tm == null) {
            try {
                this.tm = (TransactionManager)LookupContextFactory.getLookupContext(this.getClass()).getTransactionManager();
            }
            catch (NamingException e) {
                throw new RemoteException("Error looking up transaction manager", e);
            }
        }
        return this.tm;
    }

    private int getTransactionType() {
        return this.transactionType;
    }

    TransactionalExecutor getTransactionExecutor(TransformContext cxt) throws RemoteException {
        DeclarativeTransactionalExecutor transactionalExecutor = new DeclarativeTransactionalExecutor(this.getTransactionManager(), this.getTransactionType());
        return transactionalExecutor;
    }

    public Object[] run(final Object[] processArgs, final TransformContext cxt) throws TransformException, RemoteException {
        Object toRet = this.getTransactionExecutor(cxt).start(new Task(){

            public Object run() throws RemoteException, TransformException {
                return MessageFlowVolante.this.messageFlow.run(processArgs, cxt);
            }
        });
        return (Object[])toRet;
    }

    public Result run2(final Object[] processArgs, final TransformContext cxt) throws RemoteException {
        final TransactionalExecutor transactionExecutor = this.getTransactionExecutor(cxt);
        try {
            Object toRet = transactionExecutor.start(new Task(){

                public Object run() throws RemoteException, TransformException, SystemException {
                    Result result = MessageFlowVolante.this.messageFlow.run2(processArgs, cxt);
                    if (result.hasException()) {
                        transactionExecutor.setRollbackOnly();
                    }
                    return result;
                }
            });
            return (Result)toRet;
        }
        catch (TransformException e) {
            return new Result(null, e.getExceptionsAsList());
        }
    }

    public Result run2(final DataObject input, final TransformContext cxt) throws RemoteException {
        final TransactionalExecutor transactionExecutor = this.getTransactionExecutor(cxt);
        try {
            Object toRet = transactionExecutor.start(new Task(){

                public Object run() throws RemoteException, SystemException {
                    Result result = MessageFlowVolante.this.messageFlow.run2(input, cxt);
                    if (result.hasException()) {
                        transactionExecutor.setRollbackOnly();
                    }
                    return result;
                }
            });
            return (Result)toRet;
        }
        catch (TransformException e) {
            return new Result(null, e.getExceptionsAsList());
        }
    }

    public Object[] run(final InputSource input, final TransformContext cxt) throws TransformException, RemoteException {
        Object toRet = this.getTransactionExecutor(cxt).start(new Task(){

            public Object run() throws RemoteException, TransformException {
                return MessageFlowVolante.this.messageFlow.run(input, cxt);
            }
        });
        return (Object[])toRet;
    }

    public DataObject run(final DataObject input, final TransformContext cxt) throws TransformException, RemoteException {
        Object toRet = this.getTransactionExecutor(cxt).start(new Task(){

            public Object run() throws RemoteException, TransformException {
                return MessageFlowVolante.this.messageFlow.run(input, cxt);
            }
        });
        return (DataObject)toRet;
    }

    public DataObject createInputDataObject() throws RemoteException {
        return this.messageFlow.createInputDataObject();
    }

    public DataObject createOutputDataObject() throws RemoteException {
        return this.messageFlow.createOutputDataObject();
    }

    public List getOutputPorts() throws RemoteException {
        return this.messageFlow.getOutputPorts();
    }

    public Object call(Callable callable) throws RemoteException, Exception {
        return this.messageFlow.call(callable);
    }
}

