/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectXML;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.StringInputSource;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.xml.XMLDataObjectTableBuilder;
import com.tplus.transform.runtime.xml.dom.XMLConverterRawMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class DataObjectXMLParserImpl {
    XMLDataObjectTableBuilder builder;
    ExceptionHandler exceptionHandler = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;

    protected void initializeBuilder(DataObject obj) throws ParserConfigurationException, SAXException {
        if (this.builder == null) {
            this.builder = new XMLDataObjectTableBuilder();
        }
        this.builder.setExceptionHandler(this.exceptionHandler);
        this.builder.initialize(obj, obj.getXMLQName());
    }

    public final void parse(DataObject obj, ExceptionHandler handler, InputSource is, TransformContext cxt) throws TransformException {
        this.exceptionHandler = handler;
        if (is instanceof StringInputSource) {
            StringInputSource stringInputSource = (StringInputSource)is;
            this.parse(obj, new StringReader(stringInputSource.getAsString()), cxt);
        } else if (is instanceof XMLConverterRawMessage) {
            XMLConverterRawMessage domRawMessage = (XMLConverterRawMessage)is;
            this.parse(obj, domRawMessage.getXMLReader(), cxt);
        } else {
            String encoding = DataObjectXMLParserImpl.getPreferredEncoding(is, cxt, null);
            this.parse(obj, is.getAsStream(), encoding, cxt);
        }
    }

    public final void parse(DataObject obj, InputStream in, String encoding, TransformContext cxt) throws TransformException {
        org.xml.sax.InputSource source = new org.xml.sax.InputSource(in);
        if (encoding != null) {
            source.setEncoding(encoding);
        }
        this.parse(obj, source, cxt);
    }

    public final void parse(DataObject obj, InputStream in, TransformContext cxt) throws TransformException {
        this.parse(obj, in, null, cxt);
    }

    public final void parse(DataObject obj, Reader in, TransformContext cxt) throws TransformException {
        this.parse(obj, new org.xml.sax.InputSource(in), cxt);
    }

    public final void parse(DataObject obj, org.xml.sax.InputSource in, TransformContext cxt) throws TransformException {
        this.parseImpl(obj, in, cxt);
    }

    public final void parse(DataObject obj, XMLReader in, TransformContext cxt) throws TransformException {
        this.parseImpl(obj, in, cxt);
    }

    private final void parseImpl(DataObject obj, Object in, TransformContext cxt) throws TransformException {
        try {
            this.initializeBuilder(obj);
            boolean commentsEnabled = DataObjectXML.isCommentsEnabled(cxt);
            this.builder.setHandleComments(commentsEnabled);
            String lineFeed = DataObjectXML.getLineFeed(cxt);
            this.builder.setLineFeed(lineFeed);
            this.builder.setFastInfoSet(DataObjectXML.isFastInfoSet(cxt));
            this.builder.parse(in);
        }
        catch (ParserConfigurationException e) {
            TransformRuntimeException te = TransformRuntimeException.createFormatted("SRT150");
            te.setDetail(e);
            throw te;
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof TransformException) {
                throw (TransformException)exception;
            }
            if (exception instanceof TransformRuntimeException) {
                throw (TransformRuntimeException)exception;
            }
            if (exception instanceof SAXParseException) {
                this.throwTransformException((SAXParseException)exception);
            } else if (e instanceof SAXParseException) {
                this.throwTransformException((SAXParseException)e);
            }
            TransformException te = TransformException.createFormatted("SRT151", new Object[]{e.getMessage()});
            te.setDetail(e);
            throw te;
        }
        catch (IOException e) {
            TransformException te = TransformException.createFormatted("SRT152", e.getMessage());
            te.setDetail(e);
            throw te;
        }
    }

    private void throwTransformException(SAXParseException saxParseException) throws TransformException {
        int lineNumber = saxParseException.getLineNumber();
        int columnNumber = saxParseException.getColumnNumber();
        TransformException te = TransformException.createFormatted("SRT151", new Object[]{saxParseException.getMessage()});
        te.setContextProperty("line", lineNumber + "");
        if (columnNumber != -1) {
            te.setContextProperty("column", columnNumber + "");
        }
        te.setDetail(saxParseException);
        throw te;
    }

    public static String getPreferredEncoding(InputSource is, TransformContext tcxt, String defaultEncoding) {
        String toRet = DataObjectXMLParserImpl.getSpecifiedEncoding(tcxt);
        if (toRet == null) {
            toRet = DataObjectXMLParserImpl.getMessageEncoding(is, null);
        }
        if (toRet == null) {
            toRet = defaultEncoding;
        }
        return toRet;
    }

    public static String getSpecifiedEncoding(TransformContext tcxt) {
        if (tcxt != null) {
            String encoding = (String)tcxt.getProperty("encoding");
            return encoding;
        }
        return null;
    }

    public static String getMessageEncoding(InputSource is) {
        return DataObjectXMLParserImpl.getMessageEncoding(is, RawMessage.PLATFORM_DEFAULT_ENCODING);
    }

    public static String getMessageEncoding(InputSource is, String defaultEncoding) {
        String messageEncoding = null;
        if (is instanceof RawMessage) {
            RawMessage raw = (RawMessage)is;
            messageEncoding = raw.getSpecifiedEncoding();
        }
        if (messageEncoding == null) {
            messageEncoding = defaultEncoding;
        }
        return messageEncoding;
    }
}

