/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.CommentInfo;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DataObjectXML;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.ExceptionObject;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldMetaInfoImpl;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.LocationInfo;
import com.tplus.transform.runtime.LocationInfoImpl;
import com.tplus.transform.runtime.Locator;
import com.tplus.transform.runtime.MemoryRawOutputMessage;
import com.tplus.transform.runtime.OutputWriter;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformExceptionHelper;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.xml.CharacterEscapeHandler;
import com.tplus.transform.runtime.xml.DumbEscapeHandler;
import com.tplus.transform.runtime.xml.UTF8EscapeHandler;
import com.tplus.transform.runtime.xml.XMLDataObjectTableBuilder;
import com.tplus.transform.runtime.xml.XMLFactory;
import com.tplus.transform.runtime.xml.XMLFieldType;
import com.tplus.transform.runtime.xml.XMLWriter;
import com.tplus.transform.runtime.xml.XMLWriterImpl;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.xml.QName;
import com.tplus.transform.util.xml.XMLConstants;
import java.util.List;
import org.xml.sax.SAXException;

public class DataObjectXMLWriter
implements OutputWriter {
    public static final String IGNORE_SYNTHESIZED_FIELDS_PROPERTY = "ignoreAdditionalFields";
    private XMLWriter xmlWriter;
    private XMLWriter fastInfoSetWriter;
    private XMLWriter writer;
    private ExceptionHandler exceptionHandler = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;
    private boolean writeComments;
    private boolean includeLocationInfo;
    private boolean ignoreSynthesizedFields;

    public RawMessage write(DataObject obj, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        this.exceptionHandler = exceptionHandler;
        String encoding = DataObjectXMLWriter.getSpecifiedEncoding(cxt, "UTF-8");
        Object toRet = this.toXMLString(obj, cxt, encoding);
        MemoryRawOutputMessage rawOutputMessage = new MemoryRawOutputMessage(encoding);
        rawOutputMessage.write(toRet);
        rawOutputMessage.setEncoding(encoding);
        return rawOutputMessage;
    }

    public void write(DataObject obj, RawMessage rawMessage, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        this.exceptionHandler = exceptionHandler;
        String encoding = DataObjectXMLWriter.getSpecifiedEncoding(cxt, "UTF-8");
        rawMessage.setEncoding(encoding);
        this.toXMLString(obj, rawMessage, cxt, encoding);
    }

    public Object toXMLString(DataObject dataObj, int indent, boolean addXMLDecl) {
        this.init(null, dataObj);
        this.writer.setIndent(indent);
        return this.toXMLString(dataObj);
    }

    public Object toXMLString(DataObject dataObj) {
        try {
            return this.toXMLString(dataObj, null, "UTF-8");
        }
        catch (TransformException e) {
            e.printStackTrace();
            return "";
        }
    }

    public Object toXMLString(DataObject dataObj, TransformContext tcxt, String encoding) throws TransformException {
        this.setExceptionHandler(this.exceptionHandler);
        this.init(tcxt, dataObj);
        this.writeStartMessage0(dataObj, encoding);
        this.writeObject(dataObj);
        this.writeEndMessage0();
        return this.getOutput();
    }

    public void toXMLString(DataObject dataObj, RawMessage rawMessage, TransformContext tcxt, String encoding) throws TransformException {
        this.setExceptionHandler(this.exceptionHandler);
        this.init(tcxt, dataObj);
        this.writer.setOutputMessage(rawMessage);
        this.writeStartMessage0(dataObj, encoding);
        this.writeObject(dataObj);
        this.writeEndMessage0();
        this.getOutput();
    }

    private void writeObject(DataObject dataObj) throws TransformException {
        if (dataObj instanceof ExternalObject) {
            ExternalObject externalObject = (ExternalObject)dataObj;
            this.writeDataObject(externalObject.getHeader());
            this.writeDataObject(externalObject.getData());
            this.writeDataObject(externalObject.getTrailer());
        } else {
            this.writeRecord(dataObj, null);
        }
    }

    public Object toXMLString(DataObjectSection sec, TransformContext tcxt) throws TransformException {
        return this.toXMLString(sec, 1, tcxt);
    }

    public Object toXMLString(DataObjectSection sec, int indent, TransformContext tcxt) throws TransformException {
        this.init(tcxt, null);
        this.setIndent(indent);
        String name = sec.getName();
        name = FieldMetaInfoImpl.computeMangledName(name);
        try {
            this.toXMLString(sec, new QName(null, name), tcxt);
        }
        catch (TransformException e) {
            e.printStackTrace();
        }
        return this.getOutput();
    }

    private void toXMLString(DataObjectSection sec, QName xmlName, TransformContext tcxt) throws TransformException {
        this.setExceptionHandler(this.exceptionHandler);
        this.init(tcxt, null);
        this.writeStartMessage0(sec);
        int count = sec.getElementCount();
        for (int i = 0; i < count; ++i) {
            try {
                DataObject obj = sec.getElement(i);
                this.writeDataObject(obj);
                continue;
            }
            catch (FieldNotFoundException e) {
                // empty catch block
            }
        }
        this.writeEndMessage0();
    }

    protected void writeStartMessage0(DataObject dataObj, String encoding) throws TransformException {
        this.writeXMLHeaderDeclaration("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
        if (this.isNamespaceAware(dataObj)) {
            QName qName = dataObj.getXMLQName();
            this.startPrefixMapping("", qName.getNamespaceURI());
        }
        this.writeElementObjectComments(dataObj);
        this.startElement(dataObj.getXMLQName());
    }

    protected void writeStartMessage0(DataObjectSection dataObj) throws TransformException {
        this.writeXMLHeaderDeclaration("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        QName qName = new QName(null, dataObj.getName());
        this.startElement(qName);
    }

    private boolean isNamespaceAware(DataObject dataObj) {
        QName qName = dataObj.getXMLQName();
        return StringUtils.isNotEmpty(qName.getNamespaceURI());
    }

    protected void writeEndMessage0() throws TransformException {
        this.endElement();
    }

    private void writeDataObject(DataObject dataObject) throws TransformException {
        if (dataObject != null) {
            QName qName = dataObject.getXMLQName();
            XMLFieldType fieldXMLType = dataObject.getFieldXMLType();
            if (fieldXMLType != XMLFieldType.ELEMENT) {
                qName = null;
            }
            this.writeRecord(dataObject, qName);
        }
    }

    public void init(TransformContext tcxt, Object clsRef) {
        this.writer = this.createWriter(tcxt, clsRef);
        this.writer.init();
        this.setLineSeparator(tcxt);
        this.setCharacterEscapeHandler(this.getEscapeHandler(tcxt));
        this.writeComments = DataObjectXML.isCommentsEnabled(tcxt);
        this.includeLocationInfo = LocationInfoImpl.isLocationInfo(tcxt);
    }

    private XMLWriter createWriter(TransformContext tcxt, Object clsRef) throws TransformRuntimeException {
        boolean fastInfoset = DataObjectXML.isFastInfoSet(tcxt);
        if (fastInfoset) {
            if (this.fastInfoSetWriter == null) {
                this.fastInfoSetWriter = this.createFastInfoSetWriter(clsRef);
            }
            return this.fastInfoSetWriter;
        }
        if (this.xmlWriter == null) {
            this.xmlWriter = new XMLWriterImpl();
        }
        return this.xmlWriter;
    }

    private XMLWriter createFastInfoSetWriter(Object clsRef) throws TransformRuntimeException {
        try {
            XMLFactory fastInfoSetXMLFactory = XMLDataObjectTableBuilder.newFastInfoSetXMLFactory(clsRef);
            return fastInfoSetXMLFactory.createXMLWriter();
        }
        catch (Exception e) {
            throw new TransformRuntimeException("Error creating Fast Infoset writer", e);
        }
    }

    void setCharacterEscapeHandler(CharacterEscapeHandler characterEscapeHandler) {
        this.writer.setCharacterEscapeHandler(characterEscapeHandler);
    }

    protected ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected CharacterEscapeHandler getEscapeHandler(TransformContext tcxt) {
        String value;
        if (tcxt != null && (value = (String)tcxt.getProperty("xml.escape")) != null && value.equals("minimal")) {
            return UTF8EscapeHandler.getInstance();
        }
        return DumbEscapeHandler.getInstance();
    }

    private void setLineSeparator(TransformContext tcxt) {
        String sep;
        if (tcxt != null && (sep = (String)tcxt.getProperty("line.separator")) != null) {
            this.writer.setLineSeparator(sep);
        }
    }

    public void setIndent(int indent) {
        this.writer.setIndent(indent);
    }

    public Object getOutput() throws TransformException {
        return this.writer.getOutput();
    }

    public void writeXMLHeaderDeclaration(String xmlDecl) throws TransformException {
        this.writer.writeXMLDeclaration(xmlDecl);
    }

    public void writeXMLDeclaration(String xmlDecl) throws TransformException {
        this.writer.writeXMLDeclaration(xmlDecl);
    }

    public void writeTopLevelHeader(String docType) throws TransformException {
        this.writer.writeTopLevelHeader(docType);
    }

    public void startPrefixMapping(String newPrefix, String value) {
        try {
            this.writer.startPrefixMapping(newPrefix, value);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void addPreferredPrefix(String newPrefix, String value) {
        this.writer.addPreferredPrefix(newPrefix, value);
    }

    public void writeAttribute(QName qName, String value) throws TransformException {
        this.writer.writeAttribute(qName, value);
    }

    protected void startElement(QName qName) throws TransformException {
        this.writer.startElement(qName);
    }

    protected void endElement() throws TransformException {
        this.writer.endElement();
    }

    protected void writeRecord(DataObject obj, QName qName) throws TransformException {
        if (obj == null) {
            return;
        }
        DataObjectMetaInfo metaInfo = obj.getMetaInfo();
        this.validateChild(obj);
        if (qName != null) {
            this.writeElementObjectComments(obj);
            this.writer.startElement(qName, this.isMixedContent(metaInfo));
        }
        if (this.hasAttributes(metaInfo)) {
            this.writeAttributes(obj);
        }
        if (this.hasValueField(metaInfo) || this.hasElements(metaInfo)) {
            if (this.hasValueField(metaInfo)) {
                this.writeValue(obj);
                this.writeElements(obj, metaInfo);
            } else {
                this.writeElements(obj, metaInfo);
            }
        }
        if (obj instanceof ExceptionObject) {
            FastStringBuffer toRet = new FastStringBuffer();
            TransformExceptionHelper.writeExceptionContext((ExceptionObject)obj, toRet);
            this.writer.insertText(toRet.toString());
        }
        if (qName != null) {
            this.writer.endElement();
        }
    }

    private void validateChild(DataObject obj) throws TransformException {
        DataObjectMetaInfo metaInfo = obj.getMetaInfo();
    }

    private void writeElements(DataObject obj, DataObjectMetaInfo metaInfo) throws TransformException {
        int fldCount = metaInfo.getFieldCount();
        this.ignoreSynthesizedFields = this.isIgnoreSynthesizedFields(obj);
        for (int i = 0; i < fldCount; ++i) {
            FieldMetaInfo fieldInfo = metaInfo.getFieldMetaInfo(i);
            if (fieldInfo.isSynthesized() && this.ignoreSynthesizedFields) continue;
            if (fieldInfo instanceof SectionMetaInfo) {
                SectionMetaInfo sectionMetaInfo = (SectionMetaInfo)fieldInfo;
                Object valueField = obj.getField(i);
                if (valueField == null) continue;
                if (valueField instanceof DataObject) {
                    DataObject dataObject = (DataObject)valueField;
                    this.writeRecord(dataObject, dataObject.getXMLQName());
                    continue;
                }
                DataObjectSection sec = (DataObjectSection)valueField;
                this.writeElementComments(obj, sectionMetaInfo);
                for (int si = 0; si < sec.getElementCount(); ++si) {
                    DataObject secObj = sec.getElement(si);
                    if (sectionMetaInfo.getFieldXMLType() == XMLFieldType.ELEMENT) {
                        this.writeRecord(secObj, sectionMetaInfo.getXMLQName());
                        continue;
                    }
                    if (sectionMetaInfo.getFieldXMLType() == XMLFieldType.GROUP) {
                        this.writeRecord(secObj, null);
                        continue;
                    }
                    if (sectionMetaInfo.getFieldXMLType() != XMLFieldType.ANY) continue;
                }
                continue;
            }
            FieldMetaInfo fieldMetaInfo = fieldInfo;
            if (fieldMetaInfo.getFieldXMLType() != XMLFieldType.ELEMENT) continue;
            String value = this.formatValue(obj, fieldMetaInfo);
            this.writeElementComments(obj, fieldMetaInfo);
            if (value != null) {
                this.writer.writeElement(fieldMetaInfo.getXMLQName(), value);
                continue;
            }
            if (!this.isNillable(fieldMetaInfo)) continue;
            this.writer.startElement(fieldMetaInfo.getXMLQName());
            this.writeAttribute(XMLConstants.NIL_ATTRIB, "true");
            this.writer.endElement();
        }
    }

    private String formatValue(DataObject obj, FieldMetaInfo fieldMetaInfo) throws TransformException {
        DesignerType type = fieldMetaInfo.getDesignerType();
        Object field = obj.getField(fieldMetaInfo.getIndex());
        if (field != null) {
            String value = type.format(field);
            return value;
        }
        return null;
    }

    private void writeAttributes(DataObject obj) throws TransformException {
        DataObjectMetaInfo metaInfo = obj.getMetaInfo();
        int fldCount = metaInfo.getFieldCount();
        for (int i = 0; i < fldCount; ++i) {
            FieldMetaInfo fieldInfo = metaInfo.getFieldMetaInfo(i);
            if (fieldInfo.getFieldXMLType() == XMLFieldType.ATTRIBUTE) {
                String value = this.formatValue(obj, fieldInfo);
                if (value == null) continue;
                QName qName = fieldInfo.getXMLQName();
                this.writer.writeAttribute(qName, value);
                continue;
            }
            if (fieldInfo.getFieldXMLType() != XMLFieldType.ANYATTRIBUTE) continue;
        }
    }

    private void writeValue(DataObject obj) throws FieldNotFoundException, TransformException {
        DataObjectMetaInfo metaInfo = obj.getMetaInfo();
        FieldMetaInfo valueFieldMeta = this.getValueFieldMetaInfo(metaInfo);
        if (valueFieldMeta != null) {
            String value = this.formatValue(obj, valueFieldMeta);
            if (value != null) {
                this.writer.writeValue(value);
            } else if (this.isNillable(valueFieldMeta)) {
                this.writeAttribute(XMLConstants.NIL_ATTRIB, "true");
            }
        }
    }

    public void requiredFieldMissing(DataObject obj, int index) throws TransformException {
        throw new TransformException("The mandatory field '" + obj.getQualifiedName(index) + "' is missing.");
    }

    public void onError(ExceptionObject e, DataObject obj, FieldMetaInfo nodeMetaInfo) throws TransformException {
        if (nodeMetaInfo != null && obj != null) {
            int index = nodeMetaInfo.getIndex();
            e.setFieldID(obj.getFieldID(index));
            String qName = obj.getQualifiedName(index);
            e.setFieldName(qName);
        } else if (obj != null) {
            String qName = obj.getQualifiedName();
            e.setFieldID(obj.getID());
            e.setFieldName(qName);
        }
        e.setErrorPhase("Output");
        e.setErrorType("Output Writing");
        e.setCascadable(true);
        this.getExceptionHandler().onException(e);
    }

    private boolean hasElements(DataObjectMetaInfo metaInfo) {
        return metaInfo.hasXMLElements();
    }

    private boolean hasValueField(DataObjectMetaInfo metaInfo) {
        return metaInfo.hasXMLValueField();
    }

    private boolean hasAttributes(DataObjectMetaInfo metaInfo) {
        return metaInfo.hasXMLAttributes();
    }

    private boolean isMixedContent(DataObjectMetaInfo metaInfo) {
        return metaInfo.isXMLMixedContent();
    }

    private FieldMetaInfo getValueFieldMetaInfo(DataObjectMetaInfo metaInfo) {
        return metaInfo.getXMLValueFieldMetaInfo();
    }

    private boolean isNillable(FieldMetaInfo valueFieldMeta) {
        return false;
    }

    private void writeElementComments(DataObject obj, FieldMetaInfo xmlFieldMetaInfo) throws TransformException {
        List comments;
        if (this.includeLocationInfo) {
            LocationInfo locationInfo = obj.getLocationInfo();
            this.appendLocationInfo(locationInfo, xmlFieldMetaInfo.getIndex());
        }
        if (this.writeComments && (comments = CommentInfo.getFieldComments(obj, xmlFieldMetaInfo)) != null) {
            for (int j = 0; j < comments.size(); ++j) {
                String comment = (String)comments.get(j);
                if (StringUtils.isEmpty(comment)) continue;
                this.writer.writeComment(comment);
            }
        }
    }

    private void writeElementObjectComments(DataObject obj) throws TransformException {
        List comments;
        if (this.includeLocationInfo) {
            LocationInfo locationInfo = obj.getLocationInfo();
            this.appendLocationInfo(locationInfo);
        }
        if (this.writeComments && (comments = CommentInfo.getObjectComments(obj)) != null) {
            for (int j = 0; j < comments.size(); ++j) {
                String comment = (String)comments.get(j);
                if (StringUtils.isEmpty(comment)) continue;
                this.writer.writeComment(comment);
            }
        }
    }

    public static String getSpecifiedEncoding(TransformContext tcxt) {
        String encoding = (String)tcxt.getProperty("encoding");
        return encoding;
    }

    public static String getSpecifiedEncoding(TransformContext tcxt, String defaultVaue) {
        String encoding = (String)tcxt.getProperty("encoding");
        if (encoding == null) {
            encoding = defaultVaue;
        }
        return encoding;
    }

    private void appendLocationInfo(LocationInfo locationInfo, int index) throws TransformException {
        Locator locator = locationInfo.getFieldLocation(index);
        this.appendLocation(locator);
    }

    private void appendLocationInfo(LocationInfo locationInfo) throws TransformException {
        Locator locator = locationInfo.getLocation();
        this.appendLocation(locator);
    }

    private void appendLocation(Locator locator) throws TransformException {
        if (locator != null) {
            this.writer.writeComment(locator.toString());
        }
    }

    public boolean isIgnoreSynthesizedFields(DataObject dataObject) {
        Boolean value = (Boolean)dataObject.getProperty(IGNORE_SYNTHESIZED_FIELDS_PROPERTY, Boolean.FALSE);
        return value;
    }
}

