/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.ExceptionObject;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldMetaInfoImpl;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.LocationInfo;
import com.tplus.transform.runtime.Locator;
import com.tplus.transform.runtime.MemoryRawOutputMessage;
import com.tplus.transform.runtime.OutputWriter;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.StandardRuntimeResource;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.xml.CharacterEscapeHandler;
import com.tplus.transform.runtime.xml.DumbEscapeHandler;
import com.tplus.transform.runtime.xml.UTF8EscapeHandler;
import com.tplus.transform.util.xml.QName;
import com.tplus.transform.util.xml.XMLUtils;
import java.util.Map;

public class DataObjectXMLWriter2
implements OutputWriter {
    protected static final String lineSeparator = "\n";
    protected static final String fullindent = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    private ExceptionHandler exceptionHandler = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;
    private static final boolean includeLocationInfo = false;
    private static final int INITIAL_CAPACITY = 2000;
    private static final String XML_ESCAPE = "xml.escape";
    FastStringBuffer toRet;
    int indent = 1;
    CharacterEscapeHandler escapeHandler = DumbEscapeHandler.getInstance();

    private static String indentStr(int val) {
        return fullindent.substring(0, val);
    }

    private void initalize() {
        this.toRet = new FastStringBuffer(2000);
        this.toRet.setLength(0);
        this.indent = 1;
        this.escapeHandler = DumbEscapeHandler.getInstance();
    }

    public String toXMLString(DataObject dataObj) {
        return this.toXMLString(dataObj, true);
    }

    public String toXMLString(DataObject dataObj, boolean addXMLDecl) {
        this.initalize();
        this.toXMLString0(dataObj, addXMLDecl);
        return this.getOutput();
    }

    public String toXMLString(DataObject dataObj, int indent, boolean addXMLDecl) {
        this.initalize();
        this.setIndent(indent);
        this.toXMLString0(dataObj, addXMLDecl);
        return this.getOutput();
    }

    private void toXMLString0(DataObject dataObj, boolean addXMLDecl) {
        if (addXMLDecl) {
            this.toRet.append(DataObjectXMLWriter2.getXMLDeclaration());
        }
        String rootTag = dataObj.getRootXMLTag();
        this.appendIndent(this.indent - 1);
        this.toRet.append('<').append(rootTag).append('>').append(lineSeparator);
        this.toXMLString0(dataObj);
        this.appendIndent(this.indent - 1);
        this.toRet.append("</").append(rootTag).append('>').append(lineSeparator);
    }

    public static String getXMLDeclaration() {
        StringBuffer toLocalRet = new StringBuffer();
        toLocalRet.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>").append(lineSeparator);
        return toLocalRet.toString();
    }

    private void toXMLString0(DataObject dataObj) {
        if (this.indent < 1) {
            throw StandardRuntimeResource.createIllegalArgumentExceptionFormatted("SRT153");
        }
        DataObjectMetaInfo metaInfo = dataObj.getMetaInfo();
        int count = metaInfo.getFieldCount();
        for (int i = 0; i < count; ++i) {
            try {
                QName qName;
                FieldMetaInfo fieldMetaInfo = metaInfo.getFieldMetaInfo(i);
                Object obj = dataObj.getField(i);
                if (obj instanceof DataObjectSection) {
                    this.toXMLString((DataObjectSection)obj, fieldMetaInfo);
                    continue;
                }
                if (obj instanceof DataObject) {
                    qName = fieldMetaInfo.getXMLQName();
                    this.toXMLString(qName, (DataObject)obj);
                    continue;
                }
                if (obj == null) continue;
                qName = fieldMetaInfo.getXMLQName();
                DesignerType type = fieldMetaInfo.getDesignerType();
                this.appendIndent(this.indent);
                this.toRet.append('<').append(qName.getLocalPart()).append('>');
                String str = type.format(obj);
                this.escapeHandler.escape(str, this.toRet, false);
                this.toRet.append("</").append(qName.getLocalPart()).append('>');
                this.toRet.append(lineSeparator);
                continue;
            }
            catch (FieldNotFoundException e) {
                // empty catch block
            }
        }
        if (dataObj instanceof ExceptionObject) {
            ExceptionObject mapObject = (ExceptionObject)dataObj;
            Map exceptionContext = mapObject.getExceptionContext();
            for (String fieldName : exceptionContext.keySet()) {
                Object value = exceptionContext.get(fieldName);
                this.toRet.append(DataObjectXMLWriter2.indentStr(1)).append(DataObjectXMLWriter2.tagStart(fieldName));
                this.toRet.append(XMLUtils.fixXMLCharData(value.toString()));
                this.toRet.append(DataObjectXMLWriter2.tagEnd(fieldName)).append(lineSeparator);
            }
        }
    }

    public static String tagStart(String tag) {
        return "<" + tag + ">";
    }

    public static String tagEnd(String tag) {
        return "</" + tag + ">";
    }

    private void appendLocationInfo(LocationInfo locationInfo, int index) {
        Locator locator = locationInfo.getFieldLocation(index);
        this.appendLocation(locator);
    }

    private void appendLocation(Locator locator) {
        if (locator != null) {
            this.toRet.append(" <!-- ").append(locator.toString()).append(" -->");
        }
    }

    public String toXMLString(DataObjectSection sec) {
        return this.toXMLString(sec, 1);
    }

    public String toXMLString(DataObjectSection sec, int indent) {
        this.initalize();
        this.setIndent(indent);
        String name = "DataObject";
        if (sec instanceof DataObjectSection) {
            name = sec.getName();
        }
        name = FieldMetaInfoImpl.computeMangledName(name);
        this.toXMLString(sec, new QName(null, name));
        return this.getOutput();
    }

    private void toXMLString(DataObjectSection sec, FieldMetaInfo fieldMetaInfo) {
        this.toXMLString(sec, fieldMetaInfo.getXMLQName());
    }

    private void toXMLString(DataObjectSection sec, QName xmlName) {
        int count = sec.getElementCount();
        for (int i = 0; i < count; ++i) {
            try {
                DataObject obj = sec.getElement(i);
                this.toXMLString(xmlName, obj);
                continue;
            }
            catch (FieldNotFoundException e) {
                // empty catch block
            }
        }
    }

    void appendIndent(int indent) {
        this.toRet.append('\t', indent);
    }

    private void toXMLString(QName qName, DataObject obj) {
        this.appendIndent(this.indent);
        this.toRet.append('<').append(qName.getLocalPart()).append('>').append(lineSeparator);
        ++this.indent;
        this.toXMLString0(obj);
        --this.indent;
        this.appendIndent(this.indent);
        this.toRet.append("</").append(qName.getLocalPart()).append('>');
        this.toRet.append(lineSeparator);
    }

    public CharacterEscapeHandler getEscapeHandler() {
        return this.escapeHandler;
    }

    public void setEscapeHandler(CharacterEscapeHandler escapeHandler) {
        this.escapeHandler = escapeHandler;
    }

    public RawMessage write(DataObject obj, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        this.initalize();
        this.exceptionHandler = exceptionHandler;
        this.setEscapeHandler(DataObjectXMLWriter2.getEscapeHandler(cxt));
        this.toXMLString0(obj, true);
        MemoryRawOutputMessage rawOutputMessage = new MemoryRawOutputMessage("UTF-8");
        rawOutputMessage.write(this.toRet);
        this.toRet.setLength(0);
        this.toRet = null;
        return rawOutputMessage;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    protected static CharacterEscapeHandler getEscapeHandler(TransformContext tcxt) {
        String value;
        if (tcxt != null && (value = (String)tcxt.getProperty(XML_ESCAPE)) != null && value.equals("minimal")) {
            return UTF8EscapeHandler.getInstance();
        }
        return DumbEscapeHandler.getInstance();
    }

    private String getOutput() {
        return this.toRet.toString();
    }
}

