/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.xml.CharacterEscapeHandler;

public class DumbEscapeHandler
implements CharacterEscapeHandler {
    static final DumbEscapeHandler instance = new DumbEscapeHandler();

    private DumbEscapeHandler() {
    }

    private static boolean hasNonXMLCharacters(String toWrite) {
        if (toWrite == null) {
            return false;
        }
        int length = toWrite.length();
        for (int i = 0; i < length; ++i) {
            char c = toWrite.charAt(i);
            if (c == '<' || c == '>' || c == '&' || c == '\'' || c == '\"') {
                return true;
            }
            if (c >= ' ' && c <= '\u007f' || c == '\r' || c == '\n' || c == '\t') continue;
            return true;
        }
        return false;
    }

    public void escape(String toWrite, FastStringBuffer writeTo, boolean attribute) {
        if (!DumbEscapeHandler.hasNonXMLCharacters(toWrite)) {
            writeTo.append(toWrite);
            return;
        }
        int length = toWrite.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = toWrite.charAt(i);
            switch (c) {
                case '<': {
                    writeTo.append("&lt;");
                    continue block7;
                }
                case '>': {
                    writeTo.append("&gt;");
                    continue block7;
                }
                case '&': {
                    writeTo.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    if (!attribute) break;
                    writeTo.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    if (!attribute) break;
                    writeTo.append("&quot;");
                    continue block7;
                }
                default: {
                    if (c >= ' ' && c <= '\u007f' || c == '\r' || c == '\n' || c == '\t') break;
                    writeTo.append("&#").append((int)c).append(";");
                    continue block7;
                }
            }
            writeTo.append(c);
        }
    }

    public static DumbEscapeHandler getInstance() {
        return instance;
    }
}

