/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml;

import com.tplus.transform.lang.FastStringBuffer;

public abstract class WhiteSpaceProcessor {
    public static String replace(String text) {
        int i;
        for (i = text.length() - 1; i >= 0 && !WhiteSpaceProcessor.isWhiteSpaceExceptSpace(text.charAt(i)); --i) {
        }
        if (i < 0) {
            return text;
        }
        FastStringBuffer buf = new FastStringBuffer(text);
        buf.setCharAt(i--, ' ');
        while (i >= 0) {
            if (WhiteSpaceProcessor.isWhiteSpaceExceptSpace(buf.charAt(i))) {
                buf.setCharAt(i, ' ');
            }
            --i;
        }
        return buf.toString();
    }

    public static String trim(String text) {
        int end;
        int start;
        int len = text.length();
        for (start = 0; start < len && WhiteSpaceProcessor.isWhiteSpace(text.charAt(start)); ++start) {
        }
        for (end = len - 1; end > start && WhiteSpaceProcessor.isWhiteSpace(text.charAt(end)); --end) {
        }
        if (start == 0 && end == len - 1) {
            return text;
        }
        return text.substring(start, end + 1);
    }

    public static String collapse(String text) {
        int s;
        int len = text.length();
        for (s = 0; s < len && !WhiteSpaceProcessor.isWhiteSpace(text.charAt(s)); ++s) {
        }
        if (s == len) {
            return text;
        }
        FastStringBuffer result = new FastStringBuffer(len);
        if (s != 0) {
            for (int i = 0; i < s; ++i) {
                result.append(text.charAt(i));
            }
            result.append(' ');
        }
        boolean inStripMode = true;
        for (int i = s + 1; i < len; ++i) {
            char ch = text.charAt(i);
            boolean b = WhiteSpaceProcessor.isWhiteSpace(ch);
            if (inStripMode && b) continue;
            inStripMode = b;
            if (inStripMode) {
                result.append(' ');
                continue;
            }
            result.append(ch);
        }
        len = result.length();
        if (len > 0 && result.charAt(len - 1) == ' ') {
            result.setLength(len - 1);
        }
        return result.toString();
    }

    public static final boolean isWhiteSpace(FastStringBuffer s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (WhiteSpaceProcessor.isWhiteSpace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isWhiteSpace(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (WhiteSpaceProcessor.isWhiteSpace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhiteSpace(char[] ch, int start, int length) {
        for (int i = start + length - 1; i >= start; --i) {
            if (WhiteSpaceProcessor.isWhiteSpace(ch[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }

    protected static final boolean isWhiteSpaceExceptSpace(char ch) {
        if (ch >= ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r';
    }
}

