/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.ExceptionObject;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.LocationInfo;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.xml.WhiteSpaceProcessor;
import com.tplus.transform.runtime.xml.XMLFactory;
import com.tplus.transform.runtime.xml.XMLFieldType;
import com.tplus.transform.runtime.xml.dom.DOM2SAX;
import com.tplus.transform.util.ArrayStack;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import com.tplus.transform.util.xml.NamespaceContextImpl;
import com.tplus.transform.util.xml.QName;
import com.tplus.transform.util.xml.XMLConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDataObjectTableBuilder
extends DefaultHandler
implements LexicalHandler {
    protected static Log log = LogFactory.getLog(XMLDataObjectTableBuilder.class);
    private XMLReader plainXMLParser;
    private XMLReader fastInfoSetParser;
    private XMLReader xmlReader;
    ArrayStack recordStack = new ArrayStack();
    private DataObject specifiedRootObject;
    private DataObject rootRecord;
    private DataObject currentRecord;
    private FastStringBuffer elementValue = new FastStringBuffer(100);
    private Locator locator;
    boolean valueExpected = false;
    private QName tempQName = new QName("", "");
    private QName tempAttribQName = new QName("", "");
    ExceptionHandler exceptionHandler = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;
    NamespaceContextImpl namespaceContext = new NamespaceContextImpl();
    private boolean namespaceAware = true;
    private QName rootElementTag;
    private static Set ignorableAttribs = new HashSet();
    private List comments = new ArrayList();
    private boolean handleComments;
    private String lineFeed;
    private boolean fastInfoSet;
    static final Set knownFields;
    protected static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    XMLFactory fastInfoSetXMLParserFactory;
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";

    private XMLReader createXMLParser() throws ParserConfigurationException, SAXException {
        if (this.plainXMLParser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(this.isNamespaceAware());
            this.plainXMLParser = factory.newSAXParser().getXMLReader();
        }
        return this.plainXMLParser;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public boolean isHandleComments() {
        return this.handleComments;
    }

    public void setHandleComments(boolean handleComments) {
        this.handleComments = handleComments;
    }

    public String getLineFeed() {
        return this.lineFeed;
    }

    public void setLineFeed(String lineFeed) {
        this.lineFeed = lineFeed;
    }

    public void setFastInfoSet(boolean fastInfoSet) {
        this.fastInfoSet = fastInfoSet;
    }

    private String fixValue(String val) {
        return XMLDataObjectTableBuilder.fixValue(val, this.lineFeed);
    }

    public static String fixValue(String val, String lineFeed) {
        if (lineFeed != null) {
            val = StringUtils.replace(val, "\n", lineFeed);
        }
        return val;
    }

    public void initialize(DataObject specifiedRoot, QName rootElementTag) throws SAXException, ParserConfigurationException {
        this.xmlReader = this.plainXMLParser = this.createXMLParser();
        if (this.fastInfoSet) {
            if (this.fastInfoSetParser == null) {
                try {
                    this.fastInfoSetParser = this.createFastInfoSetParser(specifiedRoot);
                }
                catch (Exception e) {
                    throw new SAXException("Parser configuration exception", e);
                }
            }
            this.xmlReader = this.fastInfoSetParser;
        }
        this.elementValue = new FastStringBuffer(100);
        this.clearValue();
        this.specifiedRootObject = specifiedRoot;
        this.rootElementTag = rootElementTag;
        this.recordStack.clear();
        this.rootRecord = null;
        this.currentRecord = null;
        this.valueExpected = false;
        this.namespaceContext.clear();
        this.comments.clear();
    }

    public void startDocument() {
    }

    public void endDocument() {
        this.reset();
    }

    private void reset() {
        this.elementValue = null;
        this.specifiedRootObject = null;
        this.rootElementTag = null;
        this.recordStack.clear();
        this.rootRecord = null;
        this.currentRecord = null;
        this.valueExpected = false;
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.namespaceContext.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
        this.namespaceContext.endPrefixMapping(prefix);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        QName tempQName = this.createQName(namespaceURI, localName, qName);
        boolean section = false;
        if (this.rootRecord == null) {
            this.checkRootElement(tempQName);
            this.rootRecord = this.currentRecord = this.specifiedRootObject;
            section = true;
            this.recordStack.push(null);
            this.addCommentsTo(this.currentRecord, null);
        } else {
            FieldMetaInfo fieldInfo = this.getElementInfo(this.currentRecord, tempQName);
            this.recordStack.push(fieldInfo);
            if (fieldInfo != null) {
                if (fieldInfo instanceof SectionMetaInfo) {
                    this.checkAndClearValue();
                    if (fieldInfo.getDesignerType() == DesignerTypes.DATAOBJECT_TYPE) {
                        DataObject elementObj;
                        this.currentRecord = elementObj = (DataObject)this.currentRecord.getField(fieldInfo.getIndex());
                        section = true;
                    } else {
                        DataObjectSection childSection = this.currentRecord.getSection(fieldInfo.getIndex());
                        DataObject elementObj = childSection.createElement();
                        childSection.addElement(elementObj);
                        this.currentRecord = elementObj;
                        section = true;
                    }
                } else {
                    this.checkAndClearValue();
                    this.valueExpected = true;
                }
                if (section) {
                    this.addCommentsTo(this.currentRecord, null);
                } else {
                    this.addCommentsTo(this.currentRecord, fieldInfo);
                }
            }
        }
        boolean bl = this.valueExpected = !section;
        if (section) {
            this.checkFieldAttributes(attributes, tempQName);
        }
    }

    private void addCommentsTo(DataObject currentRecord, FieldMetaInfo fieldInfo) {
        if (this.handleComments) {
            if (this.comments.size() > 0) {
                LocationInfo locationInfo = currentRecord.getLocationInfo();
                for (int i = 0; i < this.comments.size(); ++i) {
                    String comment = (String)this.comments.get(i);
                    if (fieldInfo != null) {
                        locationInfo.addComment(fieldInfo.getIndex(), comment);
                        continue;
                    }
                    locationInfo.addComment(comment);
                }
            }
            this.comments.clear();
        }
    }

    private void checkFieldAttributes(Attributes attributes, QName elementQName) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            QName tempAttribQName = this.createQName(attributes, i);
            this.setAttribValue(this.currentRecord, tempAttribQName, attributes.getValue(i), elementQName);
        }
    }

    private QName createQName(Attributes attributes, int index) {
        if (this.namespaceAware) {
            this.tempAttribQName.set(attributes.getURI(index), attributes.getLocalName(index));
        } else {
            this.tempAttribQName.set(null, attributes.getQName(index));
        }
        return this.tempAttribQName;
    }

    private QName createQName(String namespaceURI, String localName, String qName) {
        if (this.namespaceAware) {
            this.tempQName.set(namespaceURI, localName);
        } else {
            this.tempQName.set(null, qName);
        }
        return this.tempQName;
    }

    private void checkRootElement(QName qName) throws SAXException {
        if (this.rootElementTag != null && !this.rootElementTag.equals(qName)) {
            TransformException ex = new TransformException("Unexpected root element " + qName + " expected " + this.rootElementTag);
            ex.setCascadable(false);
            this.onException(ex, null, null);
        }
    }

    private void checkAndClearValue() throws SAXException {
        if (this.hasValue()) {
            if (this.recordStack.size() > 1) {
                FieldMetaInfo fieldInfo = (FieldMetaInfo)this.recordStack.get(this.recordStack.size() - 2);
                if (fieldInfo != null && fieldInfo.isSection()) {
                    TransformException te = TransformException.createFormatted("SRT685", new Object[]{fieldInfo.getName()});
                    this.onException(te, this.getParentObject(this.currentRecord), fieldInfo);
                } else if (this.recordStack.size() == 2) {
                    TransformException te = TransformException.createFormatted("SRT686");
                    this.onException(te, this.rootRecord, null);
                }
            } else {
                TransformException te = TransformException.createFormatted("SRT686");
                this.onException(te, this.rootRecord, null);
            }
        }
        this.clearValue();
    }

    private DataObject getParentObject(DataObject record) {
        DataObjectSection parentSection = record.getParentSection();
        DataObject parent = parentSection != null ? parentSection.getParent() : (record != this.rootRecord ? this.rootRecord : null);
        return parent;
    }

    private boolean hasValue() {
        return this.elementValue.length() > 0 && !this.isIgnorableWhitespace(this.elementValue);
    }

    private void checkAndClearValue(DataObject currentRecord, FieldMetaInfo fieldInfo) throws SAXException {
        if (this.hasValue()) {
            TransformException te = TransformException.createFormatted("SRT685", new Object[]{fieldInfo.getName()});
            DataObjectSection dataObjectSection = currentRecord.getParentSection();
            if (dataObjectSection != null) {
                this.onException(te, dataObjectSection.getParent(), fieldInfo);
            } else {
                this.onException(te, null, null);
            }
        }
        this.clearValue();
    }

    private FieldMetaInfo getElementInfo(DataObject currentRecord, QName qName) throws SAXException {
        DataObjectMetaInfo dataObjectMetaInfo = currentRecord.getMetaInfo();
        FieldMetaInfo fieldMetaInfo = dataObjectMetaInfo.getFieldMetaInfoOrNull(qName);
        if (fieldMetaInfo != null && fieldMetaInfo.getFieldXMLType() == XMLFieldType.ELEMENT) {
            return fieldMetaInfo;
        }
        FieldMetaInfo similarFieldInfo = dataObjectMetaInfo.getFieldMetaInfoOrNull(qName.getLocalPart());
        if (similarFieldInfo != null && similarFieldInfo.getFieldXMLType() == XMLFieldType.ELEMENT) {
            this.onException(TransformException.createFormatted("SRT169A", new Object[]{qName.toString(), similarFieldInfo.getXMLQName()}), currentRecord, null);
        } else {
            this.onException(TransformException.createFormatted("SRT169B", qName.toString()), currentRecord, null);
        }
        return null;
    }

    private FieldMetaInfo getAttributeInfo(DataObject currentRecord, QName qName) throws SAXException {
        FieldMetaInfo fieldMetaInfo = currentRecord.getMetaInfo().getFieldMetaInfoOrNull(qName);
        if (fieldMetaInfo != null && fieldMetaInfo.getFieldXMLType() == XMLFieldType.ATTRIBUTE) {
            return fieldMetaInfo;
        }
        this.onException(TransformException.createFormatted("SRT169C", qName.toString()), currentRecord, null);
        return null;
    }

    private void setAttribValue(DataObject currentRecord, QName attribQName, String value, QName elementQName) throws SAXException {
        DataObjectMetaInfo info = currentRecord.getMetaInfo();
        FieldMetaInfo attrFieldInfo = this.getAttributeInfo(currentRecord, attribQName);
        if (attrFieldInfo != null) {
            try {
                value = this.fixValue(value);
                this.setFieldValue(currentRecord, attrFieldInfo, value);
            }
            catch (TransformException e) {
                this.onException(e, currentRecord, attrFieldInfo);
            }
        } else if (!ignorableAttribs.contains(this.tempAttribQName)) {
            String warning = "Unrecognized attribute '" + this.tempAttribQName + "' in element '" + elementQName + "'";
            TransformException transformException = new TransformException(warning);
            this.onException(transformException, currentRecord, null);
        }
    }

    private void setFieldValue(DataObject currentRecord, FieldMetaInfo fieldInfo, String value) throws TransformException {
        DesignerType type = fieldInfo.getDesignerType();
        Object fieldVal = type.parse(value);
        if (currentRecord.isNull(fieldInfo.getIndex())) {
            currentRecord.setField(fieldInfo.getIndex(), fieldVal);
        } else {
            String fieldName = fieldInfo.getName();
            if (!knownFields.contains(fieldName) && !type.isListType()) {
                throw TransformException.createFormatted("SRT687", fieldName);
            }
            currentRecord.setField(fieldInfo.getIndex(), fieldVal);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        FieldMetaInfo fieldInfo = (FieldMetaInfo)this.recordStack.pop();
        if (fieldInfo != null) {
            if (fieldInfo instanceof SectionMetaInfo) {
                block12: {
                    this.addCommentsTo(this.currentRecord, null);
                    SectionMetaInfo secMetaInfo = (SectionMetaInfo)fieldInfo;
                    DataObjectMetaInfo dataObjectMetaInfo = secMetaInfo.getDataObjectMetaInfo();
                    FieldMetaInfo pcMetaInfo = dataObjectMetaInfo.getXMLValueFieldMetaInfo();
                    if (pcMetaInfo != null) {
                        try {
                            String val = this.getAndClearValue();
                            if (this.currentRecord.isNull(pcMetaInfo.getIndex())) {
                                val = this.fixValue(val);
                                this.setFieldValue(this.currentRecord, pcMetaInfo, val);
                                break block12;
                            }
                            val = this.fixValue(val);
                            this.currentRecord.setField(pcMetaInfo.getIndex(), (Object)(this.currentRecord.getField(pcMetaInfo.getIndex()) + val));
                        }
                        catch (TransformException e) {
                            this.onException(e, this.currentRecord, fieldInfo);
                        }
                    } else {
                        this.checkAndClearValue(this.currentRecord, fieldInfo);
                    }
                }
                this.currentRecord = this.getParentObject(this.currentRecord);
            } else {
                this.addCommentsTo(this.currentRecord, fieldInfo);
                String val = this.getAndClearValue();
                try {
                    val = this.fixValue(val);
                    this.setFieldValue(this.currentRecord, fieldInfo, val);
                }
                catch (TransformException e) {
                    this.onException(e, this.currentRecord, fieldInfo);
                }
            }
        } else if (this.recordStack.size() > 1) {
            String val = this.getAndClearValue();
        }
        this.valueExpected = false;
    }

    private void onException(TransformException e, DataObject obj, FieldMetaInfo fieldInfo) throws SAXException {
        if (obj != null && fieldInfo != null) {
            int index = fieldInfo.getIndex();
            e.setFieldID(obj.getFieldID(index));
            String qName = obj.getQualifiedName(index);
            e.setFieldName(qName);
        }
        e.setErrorPhase("Input");
        e.setErrorType("Parsing");
        e.setCascadable(true);
        this.updateLocation(e);
        try {
            this.exceptionHandler.onException(e);
        }
        catch (TransformException e1) {
            throw new SAXException(e1);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.valueExpected) {
            this.elementValue.append(ch, start, length);
        } else if (!this.isIgnorableWhitespace(ch, start, length)) {
            this.elementValue.append(ch, start, length);
        }
    }

    private boolean isIgnorableWhitespace(char[] ch, int start, int length) {
        return WhiteSpaceProcessor.isWhiteSpace(ch, start, length);
    }

    private boolean isIgnorableWhitespace(FastStringBuffer s) {
        return WhiteSpaceProcessor.isWhiteSpace(s);
    }

    private String getAndClearValue() {
        String toRet = this.elementValue.toString();
        this.elementValue.setLength(0);
        return toRet;
    }

    private void clearValue() {
        if (this.elementValue.length() > 0) {
            this.elementValue.setLength(0);
        }
    }

    private void updateLocation(ExceptionObject ex) {
        if (this.locator != null) {
            int columnNumber = this.locator.getColumnNumber();
            int lineNumber = this.locator.getLineNumber();
            this.updateLocation(ex, lineNumber, columnNumber);
        }
    }

    private void updateLocation(ExceptionObject ex, int lineNumber, int columnNumber) {
        ex.setContextProperty("line", lineNumber + "");
        if (columnNumber != -1) {
            ex.setContextProperty("column", columnNumber + "");
        }
    }

    public void error(SAXParseException spe) throws SAXException {
        throw new SAXException("parsing error", spe);
    }

    public void fatalError(SAXParseException spe) throws SAXException {
        throw new SAXException("fatal parsing error. " + spe.getMessage(), spe);
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.handleComments) {
            this.addComment(ch, start, length);
        }
    }

    private void addComment(char[] ch, int start, int length) {
        String comment = new String(ch, start, length);
        System.out.println(comment);
        this.comments.add(comment);
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void parse(Object o) throws SAXException, IOException {
        if (o instanceof InputSource) {
            this.parse((InputSource)o);
        } else if (o instanceof Node) {
            this.parse((Node)o);
        } else if (o instanceof XMLReader) {
            this.parse((XMLReader)o);
        } else if (o instanceof InputStream) {
            this.parse((InputStream)o);
        } else if (o instanceof Reader) {
            this.parse((Reader)o);
        } else {
            throw new SAXException("Unexpected source object for parsing");
        }
    }

    public void parse(InputStream in) throws SAXException, IOException {
        InputSource ins = new InputSource(in);
        this.parse(ins);
    }

    public void parse(Reader in) throws SAXException, IOException {
        InputSource ins = new InputSource(in);
        this.parse(ins);
    }

    public void parse(Node dom) throws SAXException, IOException {
        DOM2SAX dom2SAX = new DOM2SAX(dom);
        this.initParserInstance(dom2SAX);
        dom2SAX.parse();
    }

    public void parse(XMLReader reader) throws SAXException, IOException {
        this.initParserInstance(reader);
        reader.parse((InputSource)null);
    }

    public void parse(InputSource ins) throws SAXException, IOException {
        this.initParserInstance(this.xmlReader);
        this.xmlReader.parse(ins);
    }

    private void initParserInstance(XMLReader xmlReader) {
        xmlReader.setContentHandler(this);
        xmlReader.setEntityResolver(this);
        xmlReader.setErrorHandler(this);
        xmlReader.setDTDHandler(this);
        if (this.handleComments) {
            try {
                xmlReader.setProperty(LEXICAL_HANDLER_PROPERTY_ID, this);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }

    public void parse(File file, String dtdURL) throws SAXException, IllegalArgumentException, FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        this.parse(fis);
    }

    public void parse(File file) throws SAXException, FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        this.parse(fis);
    }

    private XMLReader createFastInfoSetParser(DataObject specifiedRoot) throws FactoryConfigurationError {
        if (this.fastInfoSetXMLParserFactory == null) {
            try {
                this.fastInfoSetXMLParserFactory = XMLDataObjectTableBuilder.newFastInfoSetXMLFactory(specifiedRoot);
            }
            catch (Exception e) {
                throw new FactoryConfigurationError(e, "Error creating Fast Infoset parser");
            }
        }
        XMLReader xmlReader = this.fastInfoSetXMLParserFactory.createXMLReader();
        this.setNamespaceAwareFeature(xmlReader);
        return xmlReader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setNamespaceAwareFeature(XMLReader xmlParser) {
        try {
            xmlParser.setFeature(NAMESPACES_FEATURE_ID, this.namespaceAware);
            if (!this.namespaceAware) return;
        }
        catch (SAXException e) {
            log.warn("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
        }
    }

    public static XMLFactory newFastInfoSetXMLFactory(Object specifiedRoot) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        ClassLoader loader = null;
        if (specifiedRoot != null) {
            loader = specifiedRoot.getClass().getClassLoader();
        }
        Class<?> aClass = loader != null ? loader.loadClass("com.tplus.transform.runtime.xml.fastinfoset.FastInfoSetXMLFactory") : Class.forName("com.tplus.transform.runtime.xml.fastinfoset.FastInfoSetXMLFactory");
        return (XMLFactory)aClass.newInstance();
    }

    static {
        ignorableAttribs.add(XMLConstants.NO_NAMESPACE_LOCATION_ATTRIB);
        ignorableAttribs.add(XMLConstants.NAMESPACE_LOCATION_ATTRIB);
        ignorableAttribs.add(XMLConstants.TYPE_ATTRIB);
        knownFields = new HashSet<String>(Arrays.asList("Message", "Type", "Severity", "Cascadable"));
    }
}

