/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml;

import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldMetaInfoImpl;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.MessageIdentifier;
import com.tplus.transform.runtime.SimpleGenericDataObject;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.util.xml.QName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLMessageIdentifier
implements MessageIdentifier {
    static DataObjectMetaInfo dataObjectMetaInfo = new DataObjectMetaInfoImpl("XMLRoot", new FieldMetaInfo[]{new FieldMetaInfoImpl("RootElement", DesignerTypes.DESIGNER_STRING_TYPE, false, false), new FieldMetaInfoImpl("FirstChildElement", DesignerTypes.DESIGNER_STRING_TYPE, false, false), new FieldMetaInfoImpl("SecondChildElement", DesignerTypes.DESIGNER_STRING_TYPE, false, false)});
    XMLRootElementParser parser;

    public static DataObject identifyXMLMessage(byte[] message) {
        XMLMessageIdentifier identifier = new XMLMessageIdentifier();
        return identifier.identifyMessage(new ByteArrayInputSource(message));
    }

    public DataObject identifyMessage(InputSource is) {
        return this.identifyMessage(is, 1);
    }

    public DataObject identifyMessage(InputSource is, int depth) {
        try {
            XMLRootElementParser parser = this.getRootElementParser();
            List list = parser.identify(is, depth);
            SimpleGenericDataObject dataObject = new SimpleGenericDataObject(null, dataObjectMetaInfo);
            if (list.size() > 0) {
                dataObject.setField(0, (Object)((QName)list.get(0)).toString());
            }
            if (list.size() > 1) {
                dataObject.setField(1, (Object)((QName)list.get(1)).toString());
            }
            return dataObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private XMLRootElementParser getRootElementParser() throws ParserConfigurationException, SAXException {
        if (this.parser == null) {
            this.parser = new XMLRootElementParser(true, false);
        }
        return this.parser;
    }

    public void init(Properties properties) {
    }

    static class XMLRootElementParser
    extends DefaultHandler {
        protected static final String EXTERNAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
        protected static final String EXTERNAL_PARAM_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
        protected static final String EXTERNAL_DTD_LOADING_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        private SAXParser parser;
        List elements = new ArrayList();
        private boolean namespaceAware;
        int recorded;
        int record;

        XMLRootElementParser(boolean namespaceAware) throws ParserConfigurationException, SAXException {
            this(namespaceAware, true);
        }

        XMLRootElementParser(boolean namespaceAware, boolean enableExternalEntities) throws ParserConfigurationException, SAXException {
            this.namespaceAware = namespaceAware;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(namespaceAware);
            factory.setFeature(EXTERNAL_ENTITIES_FEATURE, enableExternalEntities);
            factory.setFeature(EXTERNAL_PARAM_ENTITIES_FEATURE, enableExternalEntities);
            factory.setFeature(EXTERNAL_DTD_LOADING_FEATURE, enableExternalEntities);
            this.parser = factory.newSAXParser();
        }

        List identify(InputSource bytes, int depth) throws IOException, TransformException {
            this.elements.clear();
            this.record = depth;
            this.recorded = 0;
            org.xml.sax.InputSource ins = new org.xml.sax.InputSource(bytes.getAsStream());
            ins.setSystemId("");
            try {
                this.parser.parse(ins, (DefaultHandler)this);
                return new ArrayList(this.elements);
            }
            catch (SAXException e) {
                return new ArrayList(this.elements);
            }
        }

        private QName createQName(String namespaceURI, String localName, String qName) {
            QName tempQName = this.namespaceAware ? new QName(namespaceURI, localName) : new QName(null, qName);
            return tempQName;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
            QName qfName = this.createQName(namespaceURI, localName, qName);
            this.elements.add(qfName);
            ++this.recorded;
            if (this.recorded > this.record) {
                throw new SAXException("FINISHED");
            }
        }

        public org.xml.sax.InputSource resolveEntity(String publicId, String systemId) {
            if (systemId.endsWith("dtd")) {
                return new org.xml.sax.InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }
    }
}

