/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLSimpleTableBuilderDeprecated
extends HandlerBase {
    private SAXParser parser;
    private FastStringBuffer elementValue = new FastStringBuffer();
    private XMLElement rootRecord;
    private XMLElement currentRecord;
    Stack recordStack = new Stack();

    public XMLSimpleTableBuilderDeprecated() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this.parser = factory.newSAXParser();
    }

    public void initialize() {
        this.elementValue.setLength(0);
        this.rootRecord = null;
        this.currentRecord = null;
        this.recordStack.clear();
    }

    public void startDocument() {
    }

    public Map getRootRecord() {
        return this.rootRecord.children;
    }

    public void startElement(String qName, AttributeList attributes) throws SAXException {
        this.currentRecord = new XMLElement(qName);
        this.recordStack.push(this.currentRecord);
        if (this.rootRecord == null) {
            this.rootRecord = this.currentRecord;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.currentRecord.put(attributes.getName(i), attributes.getValue(i));
        }
        this.elementValue.setLength(0);
    }

    public void endElement(String qName) throws SAXException {
        try {
            this.recordStack.pop();
            if (this.currentRecord.hasChildElements()) {
                if (this.elementValue.length() > 0) {
                    // empty if block
                }
                if (this.recordStack.size() > 0) {
                    XMLElement toAdd = this.currentRecord;
                    this.currentRecord = (XMLElement)this.recordStack.peek();
                    this.currentRecord.addToSection(qName, toAdd);
                } else {
                    this.currentRecord = null;
                }
            } else {
                String val = this.elementValue.toString();
                if (this.recordStack.size() > 0) {
                    this.currentRecord = (XMLElement)this.recordStack.peek();
                    if (!this.currentRecord.hasValue(qName)) {
                        this.currentRecord.put(qName, val);
                    }
                } else {
                    this.currentRecord = null;
                }
            }
            this.elementValue.setLength(0);
        }
        catch (Exception e) {
            LogFactory.log.unexpectedError(e);
            throw new SAXException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.elementValue.append(ch, start, length);
    }

    public void error(SAXParseException spe) throws SAXException {
        throw new SAXException("parsing error", spe);
    }

    public void fatalError(SAXParseException spe) throws SAXException {
        throw new SAXException("fatal parsing error", spe);
    }

    public Map buildTable(InputStream in) throws SAXException, IOException {
        InputSource ins = new InputSource(in);
        this.parser.parse(ins, (HandlerBase)this);
        return this.getRootRecord();
    }

    public Map buildTable(Reader in) throws SAXException, IOException {
        InputSource ins = new InputSource(in);
        this.parser.parse(ins, (HandlerBase)this);
        return this.getRootRecord();
    }

    public Map buildTable(File file, String dtdURL) throws SAXException, IllegalArgumentException, FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        return this.buildTable(fis);
    }

    public Map buildTable(File file) throws SAXException, FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        return this.buildTable(fis);
    }

    public static void cmtmain(String[] args) throws Exception {
        XMLSimpleTableBuilderDeprecated builder = new XMLSimpleTableBuilderDeprecated();
        builder.buildTable(new File(args[0]));
        Map root = builder.getRootRecord();
        System.out.println(root);
    }

    static class XMLElement {
        String name;
        Map children;

        XMLElement(String name) {
            this.name = name;
        }

        void put(String fieldName, String value) {
            if (this.children == null) {
                this.children = new HashMap();
            }
            this.children.put(fieldName, value);
        }

        public void addToSection(String fieldName, XMLElement toAdd) {
            List<Map> lst;
            Object obj;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((obj = this.children.get(fieldName)) == null) {
                lst = new ArrayList();
                this.children.put(fieldName, lst);
            } else if (obj instanceof List) {
                lst = (List)obj;
            } else {
                LogFactory.log.unexpectedError(new IllegalStateException("Mixing section and field " + fieldName));
                lst = new ArrayList();
                this.children.put(fieldName, lst);
            }
            lst.add(toAdd.children);
        }

        boolean hasChildElements() {
            return this.children != null;
        }

        public boolean hasValue(String qName) {
            return this.children != null && this.children.containsKey(qName);
        }
    }
}

