/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml;

import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.util.xml.XMLUtils;

public class XMLWriterUtil {
    protected String lineseparator = System.getProperty("line.separator");
    protected static final String fullindent = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    private int indent = 0;

    public String indentStr(int val) {
        return fullindent.substring(0, val);
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int newIndent) {
        this.indent = newIndent;
    }

    public String startTag(String tagName) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + ">" + this.lineseparator;
        ++this.indent;
        return toRet;
    }

    public String endTag(String tagName) {
        --this.indent;
        String toRet = this.indentStr(this.indent) + "</" + tagName + ">" + this.lineseparator;
        return toRet;
    }

    public String tagValue(String tagName, String value) {
        if (value != null) {
            return this.indentStr(this.indent) + "<" + tagName + ">" + this.toValueString(value) + "</" + tagName + ">" + this.lineseparator;
        }
        return "";
    }

    public String tagValue(String tagName, boolean value) {
        return this.tagValue(tagName, (value ? Boolean.TRUE : Boolean.FALSE).toString());
    }

    public String tagValue(String tagName, int value) {
        return this.tagValue(tagName, Parsing.toString(value));
    }

    public String tagValueWithAttrib(String tagName, String value, String attrName, String attrVal) {
        return this.indentStr(this.indent) + "<" + tagName + " " + attrName + "=\"" + attrVal + "\">" + this.toValueString(value) + "</" + tagName + ">" + this.lineseparator;
    }

    String toValueString(String value) {
        if (value == null) {
            return "";
        }
        return XMLWriterUtil.fixXMLCharData(value);
    }

    public String tagCDATAValue(String tagName, String value) {
        if (value != null) {
            return this.indentStr(this.indent) + "<" + tagName + ">" + this.CDATAValue(value) + "</" + tagName + ">" + this.lineseparator;
        }
        return "";
    }

    public String CDATAValue(String toWrite) {
        return "<![CDATA[" + toWrite + "]]>";
    }

    public static final String fixXMLAttribute(String str) {
        return XMLUtils.fixXMLAttribute(str);
    }

    public static final String fixXMLCharData(String str) {
        return XMLUtils.fixXMLCharData(str);
    }

    public String tagWithAttr(String tagName, String attrName, String attrVal) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " " + attrName + "=\"" + XMLWriterUtil.fixAttrib(attrVal) + "\"/>" + this.lineseparator;
        return toRet;
    }

    public String tagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " " + attr1Name + "=\"" + XMLWriterUtil.fixAttrib(attr1Val) + "\" " + attr2Name + "=\"" + XMLWriterUtil.fixAttrib(attr2Val) + "\"/>" + this.lineseparator;
        return toRet;
    }

    public String tagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val, String attr3Name, String attr3Val) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " " + attr1Name + "=\"" + XMLWriterUtil.fixAttrib(attr1Val) + "\" " + attr2Name + "=\"" + XMLWriterUtil.fixAttrib(attr2Val) + "\" " + attr3Name + "=\"" + XMLWriterUtil.fixAttrib(attr3Val) + "\"/>" + this.lineseparator;
        return toRet;
    }

    public String tagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val, String attr3Name, String attr3Val, String attr4Name, String attr4Val) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " " + attr1Name + "=\"" + XMLWriterUtil.fixAttrib(attr1Val) + "\" " + attr2Name + "=\"" + XMLWriterUtil.fixAttrib(attr2Val) + "\" " + attr3Name + "=\"" + XMLWriterUtil.fixAttrib(attr3Val) + "\" " + attr4Name + "=\"" + XMLWriterUtil.fixAttrib(attr4Val) + "\"/>" + this.lineseparator;
        return toRet;
    }

    public String tagWithAttr(String tagName, String[] attrNameVal) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " ";
        for (int i = 0; i < attrNameVal.length; i += 2) {
            toRet = toRet + attrNameVal[i] + "=\"" + XMLWriterUtil.fixAttrib(attrNameVal[i + 1]) + "\" ";
        }
        toRet = toRet + "/>" + this.lineseparator;
        return toRet;
    }

    public String startTagWithAttr(String tagName, String attrName, String attrVal) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " " + attrName + "=\"" + XMLWriterUtil.fixAttrib(attrVal) + "\">" + this.lineseparator;
        ++this.indent;
        return toRet;
    }

    public static String fixNullValue(String tagValue) {
        if (tagValue == null) {
            return "";
        }
        return tagValue;
    }

    static String fixAttrib(String str) {
        if (str == null) {
            return "";
        }
        return XMLWriterUtil.fixXMLAttribute(str);
    }

    public String startTagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " " + attr1Name + "=\"" + XMLWriterUtil.fixAttrib(attr1Val) + "\" " + attr2Name + "=\"" + XMLWriterUtil.fixAttrib(attr2Val) + "\">" + this.lineseparator;
        ++this.indent;
        return toRet;
    }

    public String startTagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val, String attr3Name, String attr3Val) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " " + attr1Name + "=\"" + XMLWriterUtil.fixAttrib(attr1Val) + "\" " + attr2Name + "=\"" + XMLWriterUtil.fixAttrib(attr2Val) + "\" " + attr3Name + "=\"" + XMLWriterUtil.fixAttrib(attr3Val) + "\">" + this.lineseparator;
        ++this.indent;
        return toRet;
    }

    public String startTagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val, String attr3Name, String attr3Val, String attr4Name, String attr4Val) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " " + attr1Name + "=\"" + XMLWriterUtil.fixAttrib(attr1Val) + "\" " + attr2Name + "=\"" + XMLWriterUtil.fixAttrib(attr2Val) + "\" " + attr3Name + "=\"" + XMLWriterUtil.fixAttrib(attr3Val) + "\" " + attr4Name + "=\"" + XMLWriterUtil.fixAttrib(attr4Val) + "\">" + this.lineseparator;
        ++this.indent;
        return toRet;
    }

    public String startTagWithAttr(String tagName, String[] attrNameVal) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " ";
        for (int i = 0; i < attrNameVal.length; i += 2) {
            toRet = toRet + attrNameVal[i] + "=\"" + XMLWriterUtil.fixAttrib(attrNameVal[i + 1]) + "\" ";
        }
        toRet = toRet + ">" + this.lineseparator;
        ++this.indent;
        return toRet;
    }

    public String startTagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, boolean attr2Val) {
        return this.startTagWithAttr(tagName, attr1Name, XMLWriterUtil.fixAttrib(attr1Val), attr2Name, attr2Val ? "true" : "false");
    }
}

