/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml;

import com.tplus.transform.runtime.Validation;
import com.tplus.transform.runtime.xml.XPathValidationSupportImpl;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import com.tplus.transform.util.xml.DOMUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathValidation
extends Validation {
    protected static Log log = LogFactory.getLog(XPathValidation.class);
    String context;
    String rule;
    String actionMessage;
    private NamespaceContext nsc;
    XPathExpression contextExpr;
    private XPathExpression ruleExpr;

    XPathValidation(String context, String rule, String actionMessage, String validationName, String errorCode, String severity, boolean cascadable, NamespaceContext nsc) {
        super(validationName, errorCode, severity, cascadable);
        this.context = context;
        this.rule = rule;
        this.actionMessage = actionMessage;
        this.nsc = nsc;
    }

    public String getContext() {
        return this.context;
    }

    public String getRule() {
        return this.rule;
    }

    public String getActionMessage() {
        return this.actionMessage;
    }

    void compile() throws XPathExpressionException, XPathFactoryConfigurationException {
        if (this.contextExpr == null) {
            XPath xpath;
            XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
            if (StringUtils.isNotEmpty(this.context)) {
                xpath = factory.newXPath();
                xpath.setNamespaceContext(this.nsc);
                this.contextExpr = xpath.compile(this.context);
            }
            if (StringUtils.isNotEmpty(this.rule)) {
                xpath = factory.newXPath();
                xpath.setNamespaceContext(this.nsc);
                this.ruleExpr = xpath.compile(this.rule);
            }
        }
    }

    public List executeXPathValidation(Object root) throws XPathExpressionException {
        try {
            this.compile();
            if (XPathValidationSupportImpl.debugEnabled) {
                log.debug("Evaluating ....");
                log.debug("   context = " + this.context);
                log.debug("   rule    =" + this.rule);
            }
            return this.evaluateRule(root);
        }
        catch (XPathFactoryConfigurationException e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    List evaluateRule(Object doc) throws XPathFactoryConfigurationException, XPathExpressionException {
        NodeList nodes = (NodeList)this.evaluateXPath(doc, this.contextExpr, XPathConstants.NODESET);
        this.displayNodes(nodes);
        ArrayList<Node> toRet = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            Boolean result = (Boolean)this.evaluateXPath(node, this.ruleExpr, XPathConstants.BOOLEAN);
            if (!result.booleanValue()) {
                if (toRet == null) {
                    toRet = new ArrayList<Node>();
                }
                toRet.add(node);
            }
            if (!XPathValidationSupportImpl.debugEnabled) continue;
            log.debug("R" + (i + 1) + ":" + result);
        }
        return toRet == null ? Collections.EMPTY_LIST : toRet;
    }

    private Object evaluateXPath(Object doc, XPathExpression expr1, QName qName) throws XPathExpressionException, XPathFactoryConfigurationException {
        Object namenode = expr1.evaluate(doc, qName);
        return namenode;
    }

    private void displayNodes(NodeList nodes) {
        if (XPathValidationSupportImpl.debugEnabled) {
            if (nodes != null) {
                String result = "";
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    result = result + "<!-- ******* Match " + (i + 1) + "-->\n";
                    result = result + this.nodeToString(node);
                }
                log.debug("Result = " + nodes.getLength() + " nodes\n" + result);
            } else {
                log.debug("Result =  null nodes\n");
            }
        }
    }

    private String nodeToString(Node node) {
        String s = node instanceof Element ? DOMUtil.convertElementToXML((Element)node) : (node instanceof Attr ? node.getNodeName() + "='" + node.getNodeValue() + "'\n" : node.getNodeValue() + "\n");
        return s;
    }
}

