/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml;

import com.tplus.transform.runtime.AbstractValidationRules;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.xml.XPathValidation;
import com.tplus.transform.runtime.xml.XPathValidationSupport;
import com.tplus.transform.runtime.xml.dom.FieldBase;
import com.tplus.transform.runtime.xml.dom.MapNamespaceContext;
import com.tplus.transform.runtime.xml.dom.MessageDocument;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import com.tplus.transform.util.xml.DOMUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;

public class XPathValidationSupportImpl
implements XPathValidationSupport {
    protected static Log log = LogFactory.getLog(XPathValidationSupport.class);
    NamespaceContext nsc;
    List xpathValidations = new ArrayList();
    private AbstractValidationRules abstractValidationRules;
    static boolean debugEnabled;

    public XPathValidationSupportImpl(AbstractValidationRules abstractValidationRules, Map prefixes) {
        this.abstractValidationRules = abstractValidationRules;
        this.nsc = new MapNamespaceContext(prefixes);
    }

    public void addXPathValidation(String context, String rule, String actionMessage, String validationName, String errorCode, String severity, boolean cascadable) {
        this.xpathValidations.add(new XPathValidation(context, rule, actionMessage, validationName, errorCode, severity, cascadable, this.nsc));
    }

    public boolean hasValidations() {
        return this.xpathValidations.size() > 0;
    }

    public void executeXPathValidations(DataObject root) throws TransformException {
        if (this.xpathValidations.size() > 0) {
            debugEnabled = log.isDebugEnabled();
            MessageDocument doc = new MessageDocument(root, new HashMap());
            if (debugEnabled) {
                log.debug("DOM:" + DOMUtil.convertElementToXML(doc.getDocumentElement()));
            }
            for (int i = 0; i < this.xpathValidations.size(); ++i) {
                XPathValidation xPathValidation = (XPathValidation)this.xpathValidations.get(i);
                try {
                    List failedNodes = xPathValidation.executeXPathValidation(doc);
                    if (failedNodes.size() <= 0) continue;
                    for (int j = 0; j < failedNodes.size(); ++j) {
                        Node node = (Node)failedNodes.get(j);
                        String path = XPathValidationSupportImpl.getNodePath(node);
                        DataObject dataObject = null;
                        int index = -1;
                        if (node instanceof FieldBase) {
                            FieldBase fieldBase = (FieldBase)node;
                            dataObject = fieldBase.getParentDataObject();
                            index = fieldBase.getInfo().getIndex();
                        }
                        this.abstractValidationRules.throwFieldInvalid(xPathValidation.getActionMessage(), xPathValidation.getValidationName(), xPathValidation.getErrorCode(), xPathValidation.getSeverity(), xPathValidation.isCascadable(), path, path, dataObject, index);
                    }
                    continue;
                }
                catch (XPathExpressionException e) {
                    this.abstractValidationRules.throwFieldInvalid("XPathExpressionException:" + this.getXPathMessage(e), xPathValidation.getValidationName(), xPathValidation.getErrorCode(), xPathValidation.getSeverity(), xPathValidation.isCascadable(), null, null, null, -1, e);
                }
            }
        }
    }

    private String getXPathMessage(Throwable e) {
        if (e.getMessage() != null) {
            return e.getMessage();
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            return this.getXPathMessage(cause);
        }
        return e.getMessage();
    }

    public static String getNodePath(Node node) {
        StringBuffer toRet = new StringBuffer();
        while (node != null && node.getNodeType() != 9) {
            if (toRet.length() > 0) {
                toRet.insert(0, "/");
            }
            String name = XPathValidationSupportImpl.getNodeName(node);
            String namespace = XPathValidationSupportImpl.getNodeNamespace(node);
            int position = XPathValidationSupportImpl.getPosition(node);
            toRet.insert(0, name + "[" + (position + 1) + "]");
            node = node.getParentNode();
        }
        if (toRet.length() > 0) {
            toRet.insert(0, "/");
        }
        return toRet.toString();
    }

    private static int getPosition(Node node) {
        Node parent = node.getParentNode();
        int count = 0;
        if (parent != null) {
            for (Node nd = parent.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
                if (!XPathValidationSupportImpl.isSameNodeName(nd, node)) continue;
                if (XPathValidationSupportImpl.isSameNode(nd, node)) break;
                ++count;
            }
        }
        return count;
    }

    private static boolean isSameNodeName(Node nd, Node node) {
        return nd.getNodeName().equals(node.getNodeName());
    }

    private static boolean isSameNode(Node nd, Node node) {
        return nd == node;
    }

    private static String getNodeName(Node node) {
        String name = node.getNodeName();
        String localName = node.getLocalName();
        String uri = node.getNamespaceURI();
        return name;
    }

    private static String getNodeNamespace(Node node) {
        String uri = node.getNamespaceURI();
        return uri;
    }
}

