/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml;

import com.tplus.transform.runtime.Binary;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.handler.IInvokable;
import com.tplus.transform.runtime.xml.dom.MessageDocument;
import com.tplus.transform.util.SequencedHashMap;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTransform
implements IInvokable {
    protected static Log log = LogFactory.getLog(XSLTransform.class);
    Map templatesMap = new HashMap();
    Map transformers = new HashMap();

    public Object run(Object[] args, TransformContext cxt) throws TransformException {
        if (args.length < 2) {
            throw new TransformException("Incorrect arguments, syntax:XSLTranform(xslResource, rawData/obj)");
        }
        String xslName = (String)args[0];
        Object toTransform = args[1];
        SequencedHashMap params = new SequencedHashMap();
        if (args.length > 2) {
            String paramList = (String)args[2];
            this.prepareParams(params, paramList);
        }
        try {
            Transformer transformer = this.createTransformer(xslName);
            this.populateParams(params, transformer);
            Source src = null;
            if (toTransform instanceof RawMessage) {
                RawMessage rawMessage = (RawMessage)toTransform;
                toTransform = rawMessage.getAsObject();
            }
            if (toTransform instanceof Binary) {
                src = new StreamSource(((Binary)toTransform).getAsStream());
            } else if (toTransform instanceof byte[]) {
                src = new StreamSource(new ByteArrayInputStream((byte[])toTransform));
            } else if (toTransform instanceof String) {
                src = new StreamSource(new StringReader((String)toTransform));
            } else if (toTransform instanceof DataObject) {
                src = new DOMSource(new MessageDocument((DataObject)toTransform, new HashMap()));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult res = new StreamResult(out);
            transformer.transform(src, res);
            return new ByteArrayInputSource(out.toByteArray());
        }
        catch (TransformerException e) {
            log.error("Error creating transformer", e);
            throw new TransformException(e.getMessage(), e);
        }
    }

    private void populateParams(Map params, Transformer transformer) {
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            transformer.setParameter(key, value);
        }
    }

    private void prepareParams(Map params, String paramList) {
        String[] strings = StringUtils.split(paramList, 59);
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            String[] nameValuePair = StringUtils.split(string, 61);
            String name = nameValuePair[0];
            String value = nameValuePair[1];
            params.put(name, value);
        }
    }

    private Transformer createTransformer(String xslName) throws TransformerConfigurationException {
        Transformer transformer = (Transformer)this.transformers.get(xslName);
        if (transformer == null) {
            Templates template = (Templates)this.templatesMap.get(xslName);
            if (template == null) {
                TransformerFactory factory = TransformerFactory.newInstance();
                InputStream resourceStream = this.getClass().getResourceAsStream(xslName);
                if (resourceStream == null) {
                    throw new TransformerConfigurationException("Missing resource " + xslName);
                }
                String systemId = this.getClass().getResource(xslName).toString();
                template = factory.newTemplates(new StreamSource(resourceStream, systemId));
                this.templatesMap.put(xslName, template);
            }
            transformer = template.newTransformer();
            this.transformers.put(xslName, transformer);
        }
        transformer.clearParameters();
        return transformer;
    }
}

