/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml.dom;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.xml.XMLFieldType;
import com.tplus.transform.runtime.xml.dom.EmptyNodeList;
import com.tplus.transform.runtime.xml.dom.FieldBase;
import com.tplus.transform.runtime.xml.dom.MessageDOMException;
import com.tplus.transform.runtime.xml.dom.MessageDocument;
import com.tplus.transform.runtime.xml.dom.SectionElement;
import com.tplus.transform.runtime.xml.dom.SimpleNamedNodeMap;
import com.tplus.transform.runtime.xml.dom.SimpleNodeList;
import com.tplus.transform.runtime.xml.dom.TextNode;
import com.tplus.transform.util.xml.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

class FieldElement
extends FieldBase
implements Element {
    TextNode textNode;

    FieldElement(MessageDocument doc, SectionElement parentElement, DataObject parentObject, FieldMetaInfo info) {
        super(doc, parentElement, parentObject, info);
        if (info == null) {
            throw new IllegalArgumentException();
        }
    }

    public FieldElement(FieldElement toCopy) {
        super(toCopy);
    }

    TextNode getTextNode() {
        if (this.textNode == null) {
            this.textNode = new TextNode(this.getMessageDocument(), this, this.info);
        }
        return this.textNode;
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasAttribute(String str) {
        return false;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        return false;
    }

    public TypeInfo getSchemaTypeInfo() {
        return new FieldTypeInfo(this.info.getDesignerType().toString().toLowerCase());
    }

    public void setIdAttribute(String subFieldValue, boolean b) throws DOMException {
        throw new MessageDOMException(3, "Attempt to add child to a field");
    }

    public void setIdAttributeNS(String subFieldValue, String subFieldValue1, boolean b) throws DOMException {
        throw new MessageDOMException(3, "Attempt to add child to a field");
    }

    public void setIdAttributeNode(Attr attr, boolean b) throws DOMException {
        throw new MessageDOMException(3, "Attempt to add child to a field");
    }

    public String getLocalName() {
        return this.getNodeName();
    }

    public String getNamespaceURI() {
        return FieldElement.getQNameImpl(this.info).getNamespaceURI();
    }

    public QName getQName() {
        return FieldElement.getQNameImpl(this.info);
    }

    public void setPrefix(String prefix) {
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.getAttribute(localName);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        return this.getAttributeNode(localName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getElementsByTagName(localName);
    }

    public Node appendChild(Node toAppend) throws DOMException {
        throw new MessageDOMException(3, "Attempt to add child to a field");
    }

    public Node cloneNode(boolean deep) {
        return new FieldElement(this);
    }

    public NamedNodeMap getAttributes() {
        return new SimpleNamedNodeMap();
    }

    public NodeList getChildNodes() {
        return new SimpleNodeList(this.getTextNode());
    }

    public Node getFirstChild() {
        return this.getTextNode();
    }

    public Node getLastChild() {
        return this.getTextNode();
    }

    public Node getNextSibling() {
        if (this.parentElement != null) {
            return this.parentElement.getNextSibling(this);
        }
        return null;
    }

    public String getNodeName() {
        return FieldElement.getQNameImpl(this.info).getLocalPart();
    }

    public short getNodeType() {
        XMLFieldType fieldXMLType = FieldElement.getFieldXMLTypeImpl(this.info);
        if (fieldXMLType == XMLFieldType.ATTRIBUTE) {
            return 2;
        }
        if (fieldXMLType == XMLFieldType.ELEMENT) {
            return 1;
        }
        return 1;
    }

    public String getNodeValue() throws DOMException {
        return "";
    }

    String getFieldValue(FieldMetaInfo fieldMetaInfo) throws DOMException {
        DesignerType type = this.info.getDesignerType();
        try {
            Object fieldValue = this.getParentDataObject().getField(this.info.getIndex());
            return Parsing.runtimeObjectToString(fieldValue, type);
        }
        catch (FieldNotFoundException e) {
            throw new MessageDOMException(8, e.getMessage());
        }
    }

    void setFieldValue(String fieldValue) throws DOMException {
        DesignerType type = this.info.getDesignerType();
        try {
            Object value = type.parse(fieldValue);
            this.getParentDataObject().setField(this.info.getIndex(), value);
        }
        catch (TransformException e) {
            throw new MessageDOMException(8, e.getMessage());
        }
    }

    public Document getOwnerDocument() {
        return this.doc;
    }

    public Node getParentNode() {
        return this.parentElement;
    }

    public Node getPreviousSibling() {
        if (this.parentElement != null) {
            return this.parentElement.getPreviousSibling(this);
        }
        return null;
    }

    public boolean hasChildNodes() {
        return true;
    }

    public Node insertBefore(Node arg0, Node arg1) throws DOMException {
        throw new MessageDOMException(3, "Attempt to insert child to a field");
    }

    public Node removeChild(Node arg0) throws DOMException {
        throw new MessageDOMException(8, "Attempt to remove a child from a field");
    }

    public Node replaceChild(Node arg0, Node arg1) throws DOMException {
        throw new MessageDOMException(8, "Attempt to remove a child from a field");
    }

    public void setNodeValue(String value) throws DOMException {
        try {
            DesignerType type = this.info.getDesignerType();
            Object obj = type.parse(value);
            this.getParentDataObject().setField(this.info.getIndex(), obj);
        }
        catch (TransformException e) {
            throw new MessageDOMException(e);
        }
    }

    public String getAttribute(String arg0) {
        return "";
    }

    public Attr getAttributeNode(String arg0) {
        return null;
    }

    public NodeList getElementsByTagName(String arg0) {
        return EmptyNodeList.EMPTY;
    }

    public String getTagName() {
        return FieldElement.getQNameImpl(this.info).getLocalPart();
    }

    public void normalize() {
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new MessageDOMException(7, "Attempt to remove an attribute from a field");
    }

    public void removeAttribute(String arg0) throws DOMException {
        throw new MessageDOMException(7, "Attempt to remove an attribute from a field");
    }

    public Attr removeAttributeNode(Attr arg0) throws DOMException {
        throw new MessageDOMException(8, "Attempt to remove an attribute from a field");
    }

    public void setAttributeNS(String namespaceURI, String arg0, String arg1) throws DOMException {
        throw new MessageDOMException(7, "Attempt to set an attribute for a field");
    }

    public void setAttribute(String arg0, String arg1) throws DOMException {
        throw new MessageDOMException(7, "Attempt to set an attribute for a field");
    }

    public Attr setAttributeNodeNS(Attr arg0) throws DOMException {
        throw new MessageDOMException(7, "Attempt to set an attribute for a field");
    }

    public Attr setAttributeNode(Attr arg0) throws DOMException {
        throw new MessageDOMException(7, "Attempt to set an attribute for a field");
    }

    public static class FieldTypeInfo
    implements TypeInfo {
        private String typeName;

        public FieldTypeInfo(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getTypeNamespace() {
            return "";
        }

        public boolean isDerivedFrom(String subFieldValue, String subFieldValue1, int i) {
            return false;
        }
    }
}

