/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml.dom;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.ExternalObjectImpl;
import com.tplus.transform.runtime.SectionMetaInfoImpl;
import com.tplus.transform.runtime.xml.dom.EmptyNodeList;
import com.tplus.transform.runtime.xml.dom.MessageDOMException;
import com.tplus.transform.runtime.xml.dom.NodeBase;
import com.tplus.transform.runtime.xml.dom.SectionElement;
import com.tplus.transform.runtime.xml.dom.SimpleNodeList;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.xml.DOMUtil;
import com.tplus.transform.util.xml.NamespaceContextImpl;
import com.tplus.transform.util.xml.QName;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class MessageDocument
extends NodeBase
implements Document {
    SectionElement rootElement;
    NamespaceContextImpl namespaceContext;
    int nsIndex = 0;

    public MessageDocument(DataObject rootObj) {
        this(rootObj, new HashMap());
    }

    public MessageDocument(DataObject rootObj, Map prefixes) {
        super(null);
        SectionMetaInfoImpl sectionMetaInfo;
        DataObjectMetaInfo dataObjectMetaInfo = rootObj.getMetaInfo();
        if (rootObj instanceof ExternalObjectImpl) {
            ExternalObjectImpl externalObject = (ExternalObjectImpl)rootObj;
            QName shared = externalObject.getQNameShared();
            sectionMetaInfo = new SectionMetaInfoImpl(dataObjectMetaInfo, shared.getLocalPart());
            sectionMetaInfo.setXMLQName(shared);
        } else {
            sectionMetaInfo = new SectionMetaInfoImpl(dataObjectMetaInfo, rootObj.getRootXMLTag());
            sectionMetaInfo.setXMLQName(rootObj.getXMLQName());
        }
        this.rootElement = new SectionElement(rootObj, this, null, null, sectionMetaInfo);
        NamespaceContextImpl namespaceContext = new NamespaceContextImpl();
        for (Map.Entry entry : prefixes.entrySet()) {
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            namespaceContext.startPrefixMapping(prefix, uri);
        }
        this.namespaceContext = namespaceContext;
    }

    public String toXMLString() {
        try {
            String s = DOMUtil.convertDocToXml(this);
            return s;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return "#error";
        }
    }

    public String getNodeName() {
        return "#document";
    }

    public NodeList getChildNodes() {
        return new SimpleNodeList(this.rootElement);
    }

    public Node getFirstChild() {
        return this.rootElement;
    }

    public Node getLastChild() {
        return this.rootElement;
    }

    public Node getNextSibling() {
        return null;
    }

    public short getNodeType() {
        return 9;
    }

    public boolean hasChildNodes() {
        return true;
    }

    public Element createElement(String tagName) throws DOMException {
        throw new MessageDOMException("nodes can't be created directly");
    }

    public DocumentFragment createDocumentFragment() {
        throw new MessageDOMException("nodes can't be created directly");
    }

    public Text createTextNode(String data) {
        throw new MessageDOMException("nodes can't be created directly");
    }

    public Comment createComment(String data) {
        throw new MessageDOMException("nodes can't be created directly");
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        throw new MessageDOMException("nodes can't be created directly");
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        throw new MessageDOMException("nodes can't be created directly");
    }

    public Attr createAttribute(String name) throws DOMException {
        throw new MessageDOMException("nodes can't be created directly");
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        throw new MessageDOMException("nodes can't be created directly");
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        throw new MessageDOMException("nodes can't be created directly");
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new MessageDOMException("nodes can't be created directly");
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new MessageDOMException("nodes can't be created directly");
    }

    public NodeList getElementsByTagName(String tagname) {
        if (tagname.equals(this.getDocumentElement().getNodeName())) {
            return new SimpleNodeList(this.getDocumentElement());
        }
        return EmptyNodeList.EMPTY;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String tagname) {
        return this.getDocumentElement().getElementsByTagNameNS(namespaceURI, tagname);
    }

    public Element getElementById(String elementId) {
        return null;
    }

    public DocumentType getDoctype() {
        return null;
    }

    public DOMImplementation getImplementation() {
        return new DOMImplementation(){

            public boolean hasFeature(String feature, String version) {
                return false;
            }

            public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws DOMException {
                throw new UnsupportedOperationException("documents can't be created directly!");
            }

            public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
                throw new UnsupportedOperationException("documents can't be created directly!");
            }

            public Object getFeature(String subFieldValue, String subFieldValue1) {
                return null;
            }
        };
    }

    public Document getOwnerDocument() {
        return this;
    }

    public Element getDocumentElement() {
        return this.rootElement;
    }

    public String getInputEncoding() {
        return "UTF-8";
    }

    public String getXmlEncoding() {
        return "UTF-8";
    }

    public boolean getXmlStandalone() {
        return true;
    }

    public void setXmlStandalone(boolean b) throws DOMException {
    }

    public String getXmlVersion() {
        return "1.0";
    }

    public void setXmlVersion(String subFieldValue) throws DOMException {
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public void setStrictErrorChecking(boolean b) {
    }

    public String getDocumentURI() {
        return "";
    }

    public void setDocumentURI(String subFieldValue) {
    }

    public Node adoptNode(Node node) throws DOMException {
        throw new MessageDOMException();
    }

    public DOMConfiguration getDomConfig() {
        return null;
    }

    public void normalizeDocument() {
    }

    public Node renameNode(Node node, String subFieldValue, String subFieldValue1) throws DOMException {
        throw new MessageDOMException();
    }

    String getPrefixMapping(String uri) {
        if (StringUtils.isEmpty(uri)) {
            return null;
        }
        String s = this.namespaceContext.getPrefix(uri);
        if (s == null) {
            this.namespaceContext.startPrefixMapping("nx" + ++this.nsIndex, uri);
            s = this.namespaceContext.getPrefix(uri);
        }
        return s;
    }
}

