/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml.dom;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.xml.XMLFieldType;
import com.tplus.transform.runtime.xml.dom.FieldAttribute;
import com.tplus.transform.runtime.xml.dom.FieldBase;
import com.tplus.transform.runtime.xml.dom.FieldElement;
import com.tplus.transform.runtime.xml.dom.MessageDOMException;
import com.tplus.transform.runtime.xml.dom.MessageDocument;
import com.tplus.transform.runtime.xml.dom.NodeBase;
import com.tplus.transform.runtime.xml.dom.SimpleNamedNodeMap;
import com.tplus.transform.runtime.xml.dom.SimpleNodeList;
import com.tplus.transform.runtime.xml.dom.TextNode;
import com.tplus.transform.util.xml.QName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SectionElement
extends FieldElement {
    private DataObject obj;
    private Map elementMap = new HashMap();
    private SimpleNodeList childElements;
    private SimpleNamedNodeMap atttibutes;

    SectionElement(DataObject obj, MessageDocument doc, SectionElement parent, DataObject parentObject, SectionMetaInfo info) {
        super(doc, parent, parentObject, info);
        this.obj = obj;
    }

    public DataObject getDataObject() {
        return this.obj;
    }

    public boolean hasChildNodes() {
        return true;
    }

    public boolean hasAttributes() {
        if (this.atttibutes == null) {
            this.prepare();
        }
        return this.atttibutes.size() > 0;
    }

    public String getNodeName() {
        if (this.info == null) {
            DataObjectMetaInfo dataObjectMetaInfo = this.obj.getMetaInfo();
            QName qName = FieldBase.getRootQNameImpl(dataObjectMetaInfo);
            return qName.getLocalPart();
        }
        return super.getNodeName();
    }

    public String getNamespaceURI() {
        if (this.info == null) {
            DataObjectMetaInfo dataObjectMetaInfo = this.obj.getMetaInfo();
            return this.obj.getXMLQName().getNamespaceURI();
        }
        return super.getNamespaceURI();
    }

    public String getNodeValue() {
        return "";
    }

    public NodeList getElementsByTagName(String name) {
        ArrayList<Node> list = new ArrayList<Node>();
        Node elm = (Node)this.elementMap.get(new QName("", name));
        if (elm != null) {
            list.add(elm);
        }
        return new SimpleNodeList(list);
    }

    public Node getFirstChild() {
        SimpleNodeList list = this.getChildElements();
        if (list.getLength() > 0) {
            return list.item(0);
        }
        return null;
    }

    public Node getLastChild() {
        SimpleNodeList list = this.getChildElements();
        if (list.getLength() > 0) {
            return list.item(list.getLength() - 1);
        }
        return null;
    }

    public Node getNextSibling(FieldElement fieldElement) {
        SimpleNodeList list = this.getChildElements();
        return list.getNextSibling(fieldElement);
    }

    public Node getPreviousSibling(FieldElement fieldElement) {
        SimpleNodeList list = this.getChildElements();
        return list.getPreviousSibling(fieldElement);
    }

    public NodeList getChildNodes() {
        return this.getChildElements();
    }

    public SimpleNodeList getChildElements() {
        if (this.childElements == null) {
            this.prepare();
        }
        return this.childElements;
    }

    private void prepare() {
        Object[] nodeLists = SectionElement.prepare(this.obj, this);
        this.childElements = (SimpleNodeList)nodeLists[0];
        this.atttibutes = (SimpleNamedNodeMap)nodeLists[1];
        this.createMap(this.childElements.asList());
    }

    static Object[] prepare(DataObject obj, SectionElement parentElement) {
        MessageDocument document = parentElement.getMessageDocument();
        ArrayList<NodeBase> elementList = new ArrayList<NodeBase>();
        ArrayList<FieldAttribute> attributeList = new ArrayList<FieldAttribute>();
        int count = obj.getFieldCount();
        DataObjectMetaInfo metaInfo = obj.getMetaInfo();
        for (int i = 0; i < count; ++i) {
            Object value = obj.getField(i);
            if (value == null) continue;
            FieldMetaInfo fieldMetaInfo = metaInfo.getFieldMetaInfo(i);
            XMLFieldType xmlFieldType = FieldBase.getFieldXMLTypeImpl(fieldMetaInfo);
            if (value instanceof DataObjectSection) {
                DataObject elm;
                SectionMetaInfo secInfo;
                DataObjectSection sec = (DataObjectSection)value;
                int elmCount = sec.getElementCount();
                if (xmlFieldType == XMLFieldType.ELEMENT) {
                    secInfo = (SectionMetaInfo)metaInfo.getFieldMetaInfo(i);
                    for (int j = 0; j < elmCount; ++j) {
                        elm = sec.getElement(j);
                        elementList.add(new SectionElement(elm, document, parentElement, obj, secInfo));
                    }
                    continue;
                }
                if (xmlFieldType != XMLFieldType.GROUP) continue;
                secInfo = (SectionMetaInfo)metaInfo.getFieldMetaInfo(i);
                for (int j = 0; j < elmCount; ++j) {
                    elm = sec.getElement(j);
                    Object[] subNodeLists = SectionElement.prepare(elm, parentElement);
                    elementList.addAll(((SimpleNodeList)subNodeLists[0]).asList());
                }
                continue;
            }
            if (value instanceof DataObject) {
                DataObject elm = (DataObject)value;
                QName rootQName = metaInfo.getRootQName();
                XMLFieldType xmlObjectFieldType = FieldBase.getFieldXMLObjectTypeImpl(elm, fieldMetaInfo);
                if (xmlObjectFieldType == XMLFieldType.ELEMENT && rootQName != null) {
                    elementList.add(new SectionElement(elm, document, parentElement, obj, (SectionMetaInfo)metaInfo.getFieldMetaInfo(i)));
                    continue;
                }
                if (xmlObjectFieldType != XMLFieldType.GROUP) continue;
                Object[] subNodeLists = SectionElement.prepare(elm, parentElement);
                elementList.addAll(((SimpleNodeList)subNodeLists[0]).asList());
                continue;
            }
            if (xmlFieldType == XMLFieldType.ELEMENT) {
                elementList.add(new FieldElement(document, parentElement, obj, fieldMetaInfo));
                continue;
            }
            if (xmlFieldType == XMLFieldType.ATTRIBUTE) {
                attributeList.add(new FieldAttribute(document, parentElement, obj, fieldMetaInfo));
                continue;
            }
            if (xmlFieldType != XMLFieldType.VALUE) continue;
            TextNode textNode = new TextNode(document, parentElement, fieldMetaInfo);
            elementList.add(textNode);
        }
        SimpleNodeList childElements = new SimpleNodeList(elementList);
        SimpleNamedNodeMap atttibutes = new SimpleNamedNodeMap(attributeList);
        return new Object[]{childElements, atttibutes};
    }

    private void createMap(List elementList) {
        for (int i = 0; i < elementList.size(); ++i) {
            Object o = elementList.get(i);
            if (!(o instanceof FieldElement)) continue;
            FieldElement element = (FieldElement)o;
            this.elementMap.put(element.getQName(), element);
        }
    }

    String getFieldValue(FieldMetaInfo fieldMetaInfo) throws DOMException {
        try {
            int index = fieldMetaInfo.getIndex();
            Object fieldValue = this.getDataObject().getField(index);
            return Parsing.runtimeObjectToString(fieldValue, this.getDataObject().getFieldDesignerType(index));
        }
        catch (FieldNotFoundException e) {
            throw new MessageDOMException(8, e.getMessage());
        }
    }

    public NamedNodeMap getAttributes() {
        if (this.atttibutes == null) {
            this.prepare();
        }
        return this.atttibutes;
    }

    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr != null) {
            return attr.getValue();
        }
        return "";
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        List attribList;
        if (this.atttibutes == null) {
            this.prepare();
        }
        if ((attribList = this.atttibutes.asList()) != null) {
            for (int i = 0; i < attribList.size(); ++i) {
                FieldAttribute attribute = (FieldAttribute)attribList.get(i);
                QName qName = attribute.getQName();
                if (!qName.equals(namespaceURI, localName)) continue;
                return attribute;
            }
        }
        return null;
    }

    public String getAttribute(String name) {
        return this.getAttributeNS("", name);
    }

    public Attr getAttributeNode(String name) {
        return this.getAttributeNodeNS("", name);
    }
}

