/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml.fastinfoset;

import com.tplus.transform.runtime.xml.CharacterEscapeHandler;
import com.tplus.transform.runtime.xml.XMLWriter;
import com.tplus.transform.util.xml.NamespaceContext;
import com.tplus.transform.util.xml.QName;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.SAXException;

public abstract class XMLWriterStreamWriter
implements XMLWriter {
    XMLStreamWriter streamWriter;
    PrefixManager prefixManager = new PrefixManager();

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            this.prefixManager.locallyDeclaredPrefix.put(prefix, uri);
            this.streamWriter.setPrefix(prefix, uri);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public String getOrCreatePrefix(String namespaceURI, boolean forcePrefix) {
        try {
            String prefix = this.streamWriter.getPrefix(namespaceURI);
            if (prefix == null) {
                prefix = this.prefixManager.getOrCreatePrefix(namespaceURI, true, this.streamWriter.getNamespaceContext());
                this.streamWriter.setPrefix(namespaceURI, prefix);
            }
            return prefix;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            return null;
        }
    }

    public NamespaceContext getNamespaceContext() {
        return null;
    }

    public void setIndent(int indent) {
    }

    public void setLineSeparator(String lineSep) {
    }

    public void writeXMLDeclaration(String xmlDecl) {
        try {
            this.streamWriter.writeStartDocument("1.0", "UTF-8");
            this.prefixManager.init();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void writeXMLDeclaration(String version, String encoding) {
        try {
            this.streamWriter.writeStartDocument(version, encoding);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void writeTopLevelHeader(String docType) {
        try {
            this.streamWriter.writeDTD(docType);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void startElement(QName qName) {
        try {
            String prefix = this.getOrCreatePrefix(qName.getNamespaceURI(), false);
            boolean hasPrefix = prefix != null;
            this.streamWriter.writeStartElement(prefix, qName.getLocalPart(), qName.getNamespaceURI());
            this.prefixManager.writeLocalPrefixes(this.streamWriter);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void startElement(QName qName, boolean mixedContent) {
        this.startElement(qName);
    }

    public void startElement(QName qName, String newPrefix, boolean mixedContent) {
        this.startElement(qName, mixedContent);
    }

    public void endElement() {
        try {
            this.streamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void writeAttribute(String localName, String value) {
        try {
            this.streamWriter.writeAttribute(localName, value);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void writeAttribute(QName qName, String value) {
        try {
            this.streamWriter.writeAttribute(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart(), value);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void writeAttribute(QName qName, String newPrefix, String value) {
        this.writeAttribute(qName, value);
    }

    public void writeElement(QName qName, String value) {
        this.startElement(qName);
        this.writeValue(value);
        this.endElement();
    }

    public void writeValue(String value) {
        try {
            this.streamWriter.writeCharacters(value);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void writeComment(String value) {
        try {
            this.streamWriter.writeComment(value);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void setCharacterEscapeHandler(CharacterEscapeHandler characterEscapeHandler) {
    }

    public void addPreferredPrefix(String prefix, String namespaceURI) {
    }

    public void insertText(String value) {
    }

    class PrefixManager {
        private Map locallyDeclaredPrefix = new HashMap();
        private Map preferredNamespacePrefixes = new HashMap();
        int nsIndex = 0;

        PrefixManager() {
        }

        void init() {
            this.nsIndex = 0;
        }

        String getOrCreatePrefix(String namespaceURI, boolean forcePrefix, javax.xml.namespace.NamespaceContext namespaceContext) throws XMLStreamException {
            String prefix = namespaceContext.getPrefix(namespaceURI);
            if (prefix == null) {
                if (QName.isNullNamespace(namespaceURI)) {
                    if (namespaceContext.getNamespaceURI("") != null) {
                        prefix = "";
                        this.createNewPrefix(namespaceURI, prefix);
                    }
                } else {
                    prefix = this.createNewPrefix(namespaceURI, forcePrefix);
                }
            } else if (forcePrefix && prefix.length() == 0) {
                prefix = this.createNewPrefix(namespaceURI, forcePrefix);
            }
            return prefix;
        }

        private String createNewPrefix(String namespaceURI, boolean forceNonEmpty) throws XMLStreamException {
            String prefix = this.getOrGeneratePreferredPrefix(namespaceURI, forceNonEmpty);
            this.createNewPrefix(namespaceURI, prefix);
            return prefix;
        }

        private void createNewPrefix(String namespaceURI, String prefix) throws XMLStreamException {
            XMLWriterStreamWriter.this.streamWriter.setPrefix(prefix, namespaceURI);
            this.locallyDeclaredPrefix.put(prefix, namespaceURI);
        }

        private String getOrGeneratePreferredPrefix(String namespaceURI, boolean forceNonEmpty) {
            String prefix = (String)this.preferredNamespacePrefixes.get(namespaceURI);
            if (prefix == null || forceNonEmpty && prefix.length() == 0) {
                prefix = "ns" + ++this.nsIndex;
                while (this.isPrefixInUse(prefix)) {
                    prefix = "ns" + ++this.nsIndex;
                }
            }
            return prefix;
        }

        private boolean isPrefixInUse(String prefix) {
            return this.preferredNamespacePrefixes.values().contains(prefix);
        }

        void writeLocalPrefixes(XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
            if (!this.locallyDeclaredPrefix.isEmpty()) {
                for (Map.Entry e : this.locallyDeclaredPrefix.entrySet()) {
                    String p = (String)e.getKey();
                    String u = (String)e.getValue();
                    if (u == null) {
                        u = "";
                    }
                    xmlStreamWriter.writeNamespace(p, u);
                }
                this.locallyDeclaredPrefix.clear();
            }
        }
    }
}

