/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml.soap;

import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.LookupContextFactory;
import com.tplus.transform.runtime.MessageFlow;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.xml.soap.SOAPRawMessage;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AbstractWebService {
    private LookupContext lcxt;
    private Map lookupCache = new HashMap();

    protected LookupContext getLookupContext() throws NamingException {
        if (this.lcxt == null) {
            this.lcxt = LookupContextFactory.getLookupContext(this.getClass());
        }
        return this.lcxt;
    }

    public MessageFlow lookupMessageFlow(String name) throws NamingException {
        Object obj = this.lookupCache.get(name);
        if (obj instanceof MessageFlow) {
            return (MessageFlow)obj;
        }
        MessageFlow toRet = this.getLookupContext().lookupMessageFlow(name);
        this.lookupCache.put(name, toRet);
        return toRet;
    }

    protected SOAPMessage toSOAPMessage(Object o) throws SOAPException {
        if (o instanceof SOAPRawMessage) {
            SOAPRawMessage soapRawMessage = (SOAPRawMessage)o;
            return soapRawMessage.getSOAPMessage();
        }
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage response = messageFactory.createMessage();
        if (o instanceof RawMessage) {
            RawMessage rawMessage = (RawMessage)o;
            SOAPBody soapBody = response.getSOAPBody();
            String body = null;
            try {
                body = rawMessage.getAsString();
                this.addBodyElement(body, soapBody);
            }
            catch (TransformException e) {
                e.printStackTrace();
            }
        } else if (o instanceof String) {
            String body = (String)o;
            SOAPBody soapBody = response.getSOAPBody();
            this.addBodyElement(body, soapBody);
        }
        return response;
    }

    private void addBodyElement(String body, SOAPBody soapBody) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(body));
            Document doc = docBuilder.parse(inputSource);
            SOAPBodyElement bodyElement = soapBody.addDocument(doc);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

