/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.xml.soap;

import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.xml.soap.SOAPElementMessage;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPRawMessage
extends AbstractRawMessage {
    SOAPMessage soapMessage;

    public SOAPRawMessage(SOAPMessage soapMessage) {
        this.soapMessage = soapMessage;
        this.setProperty("body-content", "body-content");
        this.setProperty("header-content", "header-content");
    }

    public RawMessage getBody() throws SOAPException {
        SOAPBody body = this.soapMessage.getSOAPBody();
        return new SOAPElementMessage((SOAPElement)body);
    }

    public String getStringProperty(String name, String defaultValue) {
        if (name.equals("body-content")) {
            return this.getBodyContentAsString();
        }
        if (name.equals("header-content")) {
            return this.getHeaderContentAsString();
        }
        try {
            return (String)this.soapMessage.getProperty(name);
        }
        catch (SOAPException e) {
            return defaultValue;
        }
    }

    private String getBodyContentAsString() {
        StringBuffer toRet = new StringBuffer();
        try {
            SOAPBody body = this.soapMessage.getSOAPBody();
            Iterator elements = body.getChildElements();
            while (elements.hasNext()) {
                Element element = (Element)elements.next();
                toRet.append(this.toXML(element));
            }
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return toRet.toString();
    }

    private String getHeaderContentAsString() {
        StringBuffer toRet = new StringBuffer();
        try {
            SOAPHeader body = this.soapMessage.getSOAPHeader();
            Iterator elements = body.getChildElements();
            while (elements.hasNext()) {
                Element element = (Element)elements.next();
                toRet.append(this.toXML(element));
            }
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return toRet.toString();
    }

    public RawMessage getHeader() throws SOAPException {
        SOAPHeader header = this.soapMessage.getSOAPHeader();
        return new SOAPElementMessage((SOAPElement)header);
    }

    public RawMessage getAttachment(String name) {
        Iterator iterator = this.soapMessage.getAttachments();
        while (iterator.hasNext()) {
            AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
        }
        return super.getAttachment(name);
    }

    public Object getAsObject() throws TransformException {
        return this.getBodyContentAsString();
    }

    String toXML(Node node) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
            StringBuffer buffer = stringWriter.getBuffer();
            return buffer.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public SOAPMessage getSOAPMessage() {
        return this.soapMessage;
    }
}

