/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.security;

import com.tplus.transform.security.Encoder;
import com.tplus.transform.security.EncodingException;
import com.tplus.transform.security.IntrusionException;
import com.tplus.transform.security.codec.Codec;
import com.tplus.transform.security.codec.UnixCodec;
import com.tplus.transform.security.codec.WindowsCodec;
import com.tplus.transform.util.ExecUtil;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DefaultEncoder
implements Encoder {
    List codecs = new ArrayList();
    protected static Log log = LogFactory.getLog(DefaultEncoder.class);
    private static final char[] IMMUNE_HTML = new char[]{',', '.', '-', '_', ' '};
    private static final char[] IMMUNE_HTMLATTR = new char[]{',', '.', '-', '_'};
    private static final char[] IMMUNE_CSS = new char[]{' '};
    private static final char[] IMMUNE_JAVASCRIPT = new char[]{',', '.', '-', '_', ' '};
    private static final char[] IMMUNE_VBSCRIPT = new char[]{' '};
    private static final char[] IMMUNE_XML = new char[]{',', '.', '-', '_', ' '};
    private static final char[] IMMUNE_SQL = new char[]{' '};
    private static final char[] IMMUNE_OS = new char[]{'-'};
    private static final char[] IMMUNE_XMLATTR = new char[]{',', '.', '-', '_'};
    private static final char[] IMMUNE_XPATH = new char[]{',', '.', '-', '_', ' '};

    public DefaultEncoder() {
    }

    public DefaultEncoder(List codecs) {
        for (Object o : codecs) {
            if (o instanceof Codec) continue;
            throw new IllegalArgumentException("Codec list must contain only Codec instances");
        }
        this.codecs = codecs;
    }

    public String canonicalize(String input) {
        if (input == null) {
            return null;
        }
        return this.canonicalize(input, true);
    }

    private String encode(char c, Codec codec, char[] baseImmune, char[] specialImmune) {
        if (this.isContained(baseImmune, c) || this.isContained(specialImmune, c)) {
            return "" + c;
        }
        return codec.encodeCharacter(new Character(c));
    }

    public String canonicalize(String input, boolean strict) {
        if (input == null) {
            return null;
        }
        String working = input;
        Codec codecFound = null;
        int mixedCount = 1;
        int foundCount = 0;
        boolean clean = false;
        while (!clean) {
            clean = true;
            Iterator i = this.codecs.iterator();
            while (i.hasNext()) {
                String old = working;
                Codec codec = (Codec)i.next();
                if (old.equals(working = codec.decode(working))) continue;
                if (codecFound != null && codecFound != codec) {
                    ++mixedCount;
                }
                codecFound = codec;
                if (clean) {
                    ++foundCount;
                }
                clean = false;
            }
        }
        if (foundCount >= 2 && mixedCount > 1) {
            if (strict) {
                throw new IntrusionException("Input validation failure", "Multiple (" + foundCount + "x) and mixed encoding (" + mixedCount + "x) detected in " + input);
            }
        } else if (foundCount >= 2) {
            if (strict) {
                throw new IntrusionException("Input validation failure", "Multiple (" + foundCount + "x) encoding detected in " + input);
            }
        } else if (mixedCount > 1 && strict) {
            throw new IntrusionException("Input validation failure", "Mixed encoding (" + mixedCount + "x) detected in " + input);
        }
        return working;
    }

    public String encodeForHTML(String input) {
        return input;
    }

    public String encodeForHTMLAttribute(String input) {
        return input;
    }

    public String encodeForCSS(String input) {
        return input;
    }

    public String encodeForJavaScript(String input) {
        return input;
    }

    public String encodeForVBScript(String input) {
        return input;
    }

    public String encodeForSQL(Codec codec, String input) {
        if (input == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            sb.append(this.encode(c, codec, CHAR_ALPHANUMERICS, IMMUNE_SQL));
        }
        return sb.toString();
    }

    public static Codec getOSCodec() {
        if (ExecUtil.isWindows()) {
            return new WindowsCodec();
        }
        return new UnixCodec();
    }

    public String encodeForOS(Codec codec, String input) {
        if (input == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            sb.append(this.encode(c, codec, CHAR_ALPHANUMERICS, IMMUNE_OS));
        }
        return sb.toString();
    }

    public String encodeForLDAP(String input) {
        StringBuffer sb = new StringBuffer();
        block7: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public String encodeForDN(String input) {
        StringBuffer sb = new StringBuffer();
        if (input.length() > 0 && (input.charAt(0) == ' ' || input.charAt(0) == '#')) {
            sb.append('\\');
        }
        block9: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case ',': {
                    sb.append("\\,");
                    continue block9;
                }
                case '+': {
                    sb.append("\\+");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '<': {
                    sb.append("\\<");
                    continue block9;
                }
                case '>': {
                    sb.append("\\>");
                    continue block9;
                }
                case ';': {
                    sb.append("\\;");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (input.length() > 1 && input.charAt(input.length() - 1) == ' ') {
            sb.insert(sb.length() - 1, '\\');
        }
        return sb.toString();
    }

    public String encodeForXPath(String input) {
        return input;
    }

    public String encodeForXML(String input) {
        return input;
    }

    public String encodeForXMLAttribute(String input) {
        return input;
    }

    public String encodeForURL(String input) throws EncodingException {
        try {
            return URLEncoder.encode(input, this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            throw new EncodingException("Encoding failure", "Encoding not supported", ex);
        }
        catch (Exception e) {
            throw new EncodingException("Encoding failure", "Problem URL decoding input", e);
        }
    }

    private String getCharacterEncoding() {
        return "utf-8";
    }

    public String decodeFromURL(String input) throws EncodingException {
        String canonical = this.canonicalize(input);
        try {
            return URLDecoder.decode(canonical, this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            throw new EncodingException("Decoding failed", "Encoding not supported", ex);
        }
        catch (Exception e) {
            throw new EncodingException("Decoding failed", "Problem URL decoding input", e);
        }
    }

    protected boolean isContained(char[] haystack, char c) {
        for (int i = 0; i < haystack.length; ++i) {
            if (c != haystack[i]) continue;
            return true;
        }
        return false;
    }

    static {
        Arrays.sort(IMMUNE_HTML);
        Arrays.sort(IMMUNE_HTMLATTR);
        Arrays.sort(IMMUNE_JAVASCRIPT);
        Arrays.sort(IMMUNE_VBSCRIPT);
        Arrays.sort(IMMUNE_XML);
        Arrays.sort(IMMUNE_XMLATTR);
        Arrays.sort(IMMUNE_XPATH);
        Arrays.sort(CHAR_LOWERS);
        Arrays.sort(CHAR_UPPERS);
        Arrays.sort(CHAR_DIGITS);
        Arrays.sort(CHAR_SPECIALS);
        Arrays.sort(CHAR_LETTERS);
        Arrays.sort(CHAR_ALPHANUMERICS);
        Arrays.sort(CHAR_PASSWORD_LOWERS);
        Arrays.sort(CHAR_PASSWORD_UPPERS);
        Arrays.sort(CHAR_PASSWORD_DIGITS);
        Arrays.sort(CHAR_PASSWORD_SPECIALS);
        Arrays.sort(CHAR_PASSWORD_LETTERS);
    }
}

